﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include "CommandLineOptions.h"

#include <string>
#include <cstdlib>

#include <nn/nn_SdkLog.h>

namespace movie { namespace sample {

    CommandLineOptions::CommandLineOptions(char** arguments_, int count_, pmr::memory_resource& mem_)
        : playlist_{pmr::polymorphic_allocator<unsigned char>{&mem_}}
    {
        for (int i = 0; i < count_; ++i) {
            NN_SDK_LOG("Command line (%d): %s\n", i, arguments_[i]);
        }

        if (count_ <= 1) {
            invalidOptions = true;
            return;
        }

        inputFileName = arguments_[1];

        std::string_view tmp_{arguments_[0]};
        working_folder_ = tmp_.substr(0,tmp_.find_last_of('\\') + 1);

        for(int options = 0; options < count_ && !invalidOptions; options ++)
        {
            if( !strcmp(arguments_[options], "-script" ) )
            {
                options++;
                invalidOptions = true;
                if( options < count_ )
                {
                    lua_file_ = arguments_[options];
                    invalidOptions = false;
                    continue;
                }
                break;
            }

            if( !strcmp(arguments_[options], "-playlist" ) )
            {
                options++;
                invalidOptions = true;
                if( options < count_ )
                {
                    playlist_file_ = arguments_[options];
                    invalidOptions = false;
                    continue;
                }
                break;
            }

            if( !strcmp(arguments_[options], "-files" ) )
            {
                options++;
                invalidOptions = true;
                while ( options < count_ )
                {
                    playlist_.emplace_back(arguments_[options]);
                    options++;
                }
                invalidOptions = false;
                continue;
                break;
            }

            if( !strcmp(arguments_[options], "-rngseed" ) )
            {
                options++;
                invalidOptions = true;
                if( options < count_ )
                {
                    rng_seed_value_ = static_cast<uint32_t>(atol(arguments_[options]));
                    invalidOptions = false;
                    continue;
                }
                break;
            }

            if( !strcmp(arguments_[options], "-a" ) )
            {
                options ++;
                invalidOptions = true;
                if( options < count_ )
                {
                    if( ( !strcmp(arguments_[options], "0") ) ||  ( !strcmp(arguments_[options], "1") ) )
                    {
                        playAudio = atoi(arguments_[options]);
                        invalidOptions = false;
                        continue;
                    }
                }
                break;
            }

            if( !strcmp(arguments_[options], "-v") )
            {
                options ++;
                invalidOptions = true;
                if( options < count_ )
                {
                    if( ( !strcmp(arguments_[options], "0") ) ||  ( !strcmp(arguments_[options], "1") ) )
                    {
                        playVideo = atoi(arguments_[options]);
                        invalidOptions = false;
                        continue;
                    }
                }
                break;
            }

            if( !strcmp(arguments_[options], "-ur") )
            {
                options ++;
                invalidOptions = true;
                if( options < count_ )
                {
                    if( ( !strcmp(arguments_[options], "0") ) ||  ( !strcmp(arguments_[options], "1") ) )
                    {
                        invalidOptions = false;
                        unrestrictedResolution = atoi(arguments_[options]);
                        continue;
                    }
                }
                break;
            }

            if( !strcmp(arguments_[options], "-l"))
            {
                options ++;
                invalidOptions = true;
                if( options < count_ )
                {
                    if( ( !strcmp(arguments_[options], "0") ) ||  ( !strcmp(arguments_[options], "1") ) )
                    {
                        setLooping = atoi(arguments_[options]);
                        invalidOptions = false;
                        continue;
                    }
                }
                break;
            }

            if (!strcmp(arguments_[options], "-h"))
            {
                options++;
                invalidOptions = true;
                if (options < count_)
                {
                    if ((!strcmp(arguments_[options], "0")) || (!strcmp(arguments_[options], "1")))
                    {
                        useHeapTracking = atoi(arguments_[options]);
                        invalidOptions = false;
                        continue;
                    }
                }
                break;
            }

            if( !strcmp(arguments_[options], "-c"))
            {
                options ++;
                invalidOptions = true;
                if( options < count_ )
                {
                    configFile = arguments_[options];
                    invalidOptions = false;
                    continue;
                }
                break;
            }

            if (!strcmp(arguments_[options], "-dm"))
            {
                options++;
                invalidOptions = true;
                if (options < count_)
                {
                    if ((!strcmp(arguments_[options], "1")) || (!strcmp(arguments_[options], "2")) )
                    {
                        int videoDecodeModeSelection = atoi(arguments_[options]);
                        switch( videoDecodeModeSelection )
                        {
                        case 1:
                            videoDecodeMode = movie::VideoDecodeMode_Cpu;
                            videoOutputFormat = movie::OutputFormat_VideoColorNv12;
                            break;
                        case 2:
                            videoDecodeMode = movie::VideoDecodeMode_NativeTexture;
                            videoOutputFormat = movie::OutputFormat_VideoColorAbgr;
                            break;
                        default:
                            break;
                        }
                        invalidOptions = false;
                        continue;
                    }
                }
                break;
            }
        }
    } // NOLINT(impl/function_size)

}}
