﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
 /*
 * Copyright 2013 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma once
#ifndef FAUDIO_SOURCE_H_
#define FAUDIO_SOURCE_H_

#include <media/stagefright/MediaSource.h>

namespace android {

struct MediaBufferGroup;

struct FAudioSource : public MediaSource {

    FAudioSource(int32_t sampleRate, int32_t numChannels);
    virtual status_t start(MetaData *params);
    virtual status_t stop();
    virtual sp<MetaData> getFormat();
    virtual status_t read(MediaBuffer **outBuf, const ReadOptions *options = NULL);

protected:
    virtual ~FAudioSource();

private:
    enum { kBufferSize = 4096 };

    bool mStarted;
    int32_t mSampleRate;
    int32_t mNumChannels;

    MediaBufferGroup *mGroup;
};

}  // namespace android

#endif // FAUDIO_SOURCE_H_
