﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nnt { namespace migration { namespace idc {

class TestUserContext
{
public:
    TestUserContext(size_t consumeCommandSize = 1024, size_t produceCommandSize = 1024) NN_NOEXCEPT;

    nn::Result Consume(void* stream, size_t size) NN_NOEXCEPT;
    void SetByteSizeToConsume(size_t size) NN_NOEXCEPT;
    nn::Result Produce(size_t* pOutProducedSize, void* outStream, size_t outStreamSize) NN_NOEXCEPT;
    size_t GetProducableByteSize() NN_NOEXCEPT;
private:
    const size_t m_ConsumeCommandSize;
    const size_t m_ProduceCommandSize;
    size_t m_ConsumedSize;
    size_t m_ProducedSize;
};

}}}
