﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_Common.h>
#include <nn/nn_Log.h>
#include <nn/os.h>
#include <nn/migration/idc/migration_Result.h>
#include <nn/migration/idc/detail/migration_Result.h>
#include <nn/result/result_HandlingUtility.h>

#include "testMigrationIdc_TestUserContext.h"

using namespace nn;

namespace nnt { namespace migration { namespace idc {

TestUserContext::TestUserContext(size_t consumeCommandSize, size_t produceCommandSize) NN_NOEXCEPT
    : m_ConsumeCommandSize(consumeCommandSize)
    , m_ProduceCommandSize(produceCommandSize)
    , m_ConsumedSize(0u)
    , m_ProducedSize(0u)
{
}

Result TestUserContext::Consume(void* stream, size_t size) NN_NOEXCEPT
{
    for( size_t i = 0; i < size; i++ )
    {
        auto expected = static_cast<Bit8>(m_ConsumedSize + i);
        auto actual = reinterpret_cast<Bit8*>(stream)[i];
        // TORIAEZU : 適当な Failure Result.
        NN_RESULT_THROW_UNLESS(expected == actual, nn::migration::idc::detail::ResultDummy());
    }
    m_ConsumedSize += size;
    NN_RESULT_THROW_UNLESS(m_ConsumedSize <= m_ConsumeCommandSize, nn::migration::idc::detail::ResultDummy());
    if( m_ConsumedSize == m_ConsumeCommandSize )
    {
        NN_RESULT_SUCCESS;
    }
    NN_RESULT_THROW(nn::migration::idc::ResultConsumeCommandContinue());
}

void TestUserContext::SetByteSizeToConsume(size_t) NN_NOEXCEPT
{
}

Result TestUserContext::Produce(size_t* pOutProducedSize, void* outStream, size_t outStreamSize) NN_NOEXCEPT
{
    *pOutProducedSize = 0u;
    for( size_t i = 0; i < outStreamSize; i++ )
    {
        reinterpret_cast<Bit8*>(outStream)[i] = static_cast<Bit8>(m_ProducedSize);
        (*pOutProducedSize)++;
        m_ProducedSize++;
        if( m_ProducedSize == m_ProduceCommandSize )
        {
            NN_RESULT_SUCCESS;
        }
    }
    NN_RESULT_THROW(nn::migration::idc::ResultProduceCommandContinue());
}

size_t TestUserContext::GetProducableByteSize() NN_NOEXCEPT
{
    return m_ProduceCommandSize;
}

}}}
