﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/migration/idc/migration_SharedBufferConnection.h>
#include <nn/migration/idc/migration_SharedBufferConnectionManager.h>
#include <nnt/result/testResult_Assert.h>
#include <nnt/nntest.h>

#include "testMigrationIdc_Common.h"
#include "testMigrationIdc_ConnectionTestCases.h"

using namespace nn;

const size_t WorkBufferSize = 32 * 1024;
NN_ALIGNAS(4096) Bit8 g_WorkBuffer[WorkBufferSize];

class MigrationIdcSharedBufferConnectionTest : public testing::Test
{
private:
    migration::idc::SharedBufferConnectionManager m_SharedBufferConnectionManager;

public:

    typedef migration::idc::SharedBufferConnection ConnectionType;

    MigrationIdcSharedBufferConnectionTest() :
        m_SharedBufferConnectionManager(g_WorkBuffer, sizeof(g_WorkBuffer))
    {
    }

    void CreateConnection(ConnectionType* pOutConnection0, ConnectionType* pOutConnection1, int bufferSize = 8 * 1024)
    {
        EXPECT_TRUE(m_SharedBufferConnectionManager.CreateConnection(pOutConnection0, pOutConnection1, bufferSize));
    }

protected:
    virtual void SetUp()
    {
    }
    virtual void TearDown()
    {
    }
};

TEST_F(MigrationIdcSharedBufferConnectionTest, BasicSendReceive)
{
    ConnectionType c0, c1;
    CreateConnection(&c0, &c1);
    TestBasicSendReceive<>(c0, c1);
}

TEST_F(MigrationIdcSharedBufferConnectionTest, BasicSendReceiveLarge)
{
    ConnectionType c0, c1;
    CreateConnection(&c0, &c1);
    TestBasicSendReceiveLarge<>(c0, c1);
}

/// 送信系のテスト

TEST_F(MigrationIdcSharedBufferConnectionTest, SendPeerClose)
{
    ConnectionType c0, c1;
    CreateConnection(&c0, &c1);
    TestSendPeerClose<>(c0, std::move(c1));
}

TEST_F(MigrationIdcSharedBufferConnectionTest, SendCancel)
{
    ConnectionType c0, c1;
    CreateConnection(&c0, &c1);
    TestSendCancel<>(c0);
}

TEST_F(MigrationIdcSharedBufferConnectionTest, SendCancelWhileSendBufferFull)
{
    ConnectionType c0, c1;
    CreateConnection(&c0, &c1);
    TestSendCancelWhileSendBufferFull<>(c0);
}

TEST_F(MigrationIdcSharedBufferConnectionTest, SendCancelAndClose)
{
    ConnectionType c0, c1;
    CreateConnection(&c0, &c1);
    TestSendCancelAndClose<>(c0, std::move(c1));
}

TEST_F(MigrationIdcSharedBufferConnectionTest, SendTimeout)
{
    ConnectionType c0, c1;
    CreateConnection(&c0, &c1);
    TestSendTimeout<>(c0);
}

TEST_F(MigrationIdcSharedBufferConnectionTest, SendLowSpeedTimeout)
{
    ConnectionType c0, c1;
    CreateConnection(&c0, &c1);
    TestSendLowSpeedTimeout<>(c0);
}

/// 受信系のテスト

TEST_F(MigrationIdcSharedBufferConnectionTest, ReceivePeerClose)
{
    ConnectionType c0, c1;
    CreateConnection(&c0, &c1);
    TestReceivePeerClose<>(c0, std::move(c1));
}

TEST_F(MigrationIdcSharedBufferConnectionTest, ReceivePeerCloseWhileReceiveBufferEmpty)
{
    ConnectionType c0, c1;
    CreateConnection(&c0, &c1);
    TestReceivePeerCloseWhileReceiveBufferEmpty<>(c0, std::move(c1));
}

TEST_F(MigrationIdcSharedBufferConnectionTest, ReceivePeerCloseWithReceiveBuffer)
{
    ConnectionType c0, c1;
    CreateConnection(&c0, &c1);
    TestReceivePeerCloseWithReceiveBuffer<>(c0, std::move(c1));
}

TEST_F(MigrationIdcSharedBufferConnectionTest, ReceiveCancel)
{
    ConnectionType c0, c1;
    CreateConnection(&c0, &c1);
    TestReceiveCancel<>(c0);
}

TEST_F(MigrationIdcSharedBufferConnectionTest, ReceiveCancelWhileReceiveBufferEmpty)
{
    ConnectionType c0, c1;
    CreateConnection(&c0, &c1);
    TestReceiveCancelWhileReceiveBufferEmpty<>(c0);
}

TEST_F(MigrationIdcSharedBufferConnectionTest, ReceiveCancelWithReceiveBuffer)
{
    ConnectionType c0, c1;
    CreateConnection(&c0, &c1);
    TestReceiveCancelWithReceiveBuffer<>(c0, c1);
}

TEST_F(MigrationIdcSharedBufferConnectionTest, ReceiveCancelAndClose)
{
    ConnectionType c0, c1;
    CreateConnection(&c0, &c1);
    TestReceiveCancelAndClose<>(c0, std::move(c1));
}

TEST_F(MigrationIdcSharedBufferConnectionTest, ReceiveTimeout)
{
    ConnectionType c0, c1;
    CreateConnection(&c0, &c1);
    TestReceiveTimeout<>(c0);
}

TEST_F(MigrationIdcSharedBufferConnectionTest, ReceiveLowSpeedTimeout)
{
    ConnectionType c0, c1;
    CreateConnection(&c0, &c1);
    TestReceiveLowSpeedTimeout<>(c0);
}
