﻿using System;
using System.Collections.ObjectModel;

namespace LdnTestBridge
{
    /// <summary>
    /// リポジトリのインタフェースです。
    /// </summary>
    /// <typeparam name="TEntity">リポジトリで管理するエンティティです。</typeparam>
    interface IRepository<TEntity> where TEntity : class
    {
        /// <summary>
        /// 全てのオブジェクトを取得します。
        /// </summary>
        ReadOnlyObservableCollection<TEntity> All
        {
            get;
        }

        /// <summary>
        /// 新しいオブジェクトを追加します。
        /// </summary>
        /// <param name="entity">新しいオブジェクトです。</param>
        /// <returns>処理の成否です。</returns>
        bool Add(TEntity entity);

        /// <summary>
        /// オブジェクトを削除します。
        /// </summary>
        /// <param name="entity">対象のオブジェクトです。</param>
        void Remove(TEntity entity);

        /// <summary>
        /// オブジェクトを検索します。
        /// </summary>
        /// <param name="pred">オブジェクトの検索に使用する Predicate です。</param>
        /// <returns>条件を満たすオブジェクトです。見つからなかった場合は null です。</returns>
        TEntity Find(Func<TEntity, bool> pred);
    }
}
