﻿Param(
    $Name,
    $Index,
    $Num,
    $Path,
    $SceneId
)

# スクリプトをロードします。
$SCRIPT_DIR = (Split-Path -Parent (Split-Path -Parent $MyInvocation.MyCommand.Path))
. $SCRIPT_DIR\Siglo\Bundle

# テスト結果を出力するディレクトリを生成します。
$TEST_NAME = (Split-Path -Path $Path -Leaf) -replace '(.+)(\.[^.]+$)','$1'
$OUT_DIR = "$SIGLO_ROOT\Integrate\Outputs\TargetManager\$TEST_NAME"
if (!(Test-Path $OUT_DIR))
{
    New-Item $OUT_DIR -ItemType Directory > $NULL
}

# テスト結果を出力するログファイルのパスを生成します。
$TIMESTAMP = (Get-Date -Format "yyyyMMddHHmmss")
$OUT_PATH = "$($OUT_DIR)\$($TIMESTAMP)_$Name.txt"

# テストコマンドを標準出力します。
$Filters = $Args
Write-Output "$RUN_ON_TARGET $Path -t $Name -- -n $Num -i $Index -s $SceneId $Filters"

# テストを実行し、結果をファイルに出力します。
$Result = @()
&$RUN_ON_TARGET $Path "-t" $Name "--" "-n" $Num "-i" $Index "-s" $SceneId $Filters | foreach {
    $Result += $_
    Write-Output $_ >> $OUT_PATH
}

# テストの標準出力を解析して各種の処理を実行します。
$Result | foreach {
    if ($_ -match "^\[LCS\] Runner Operation: ([A-Z]+)\s*([ 0-9A-Z_a-z]+)?$")
    {
        if ($Matches[1] -eq "REBOOT")
        {
            ResetTarget $Name
            ConnectToTarget $Name
        }
        elseif ($Matches[1] -eq "RESUME")
        {
            Write-Output $RUN_ON_TARGET `
                $Path "-t" $Name "--" "-n" $Num "-i" $Index "-s" $SceneId "-r" $Filters
            &$RUN_ON_TARGET `
                $Path "-t" $Name "--" "-n" $Num "-i" $Index "-s" $SceneId "-r" $Filters | foreach {
                Write-Output $_ >> $OUT_PATH
            }
        }
        elseif ($Matches[1] -eq "SET")
        {
            $Params = $Matches[2] -split ' '
            DevMenuCommandSystem $Name "debug" "set-$($Params[0])-fwdbg" `
                "--name" $Params[1] `
                "--key" $Params[2] `
                $Params[3]
        }
        elseif ($Matches[1] -eq "COMMAND")
        {
            $Params = $Matches[2] -split ' '
            DevMenuCommandSystem $Name @Params
        }
        else
        {
            throw "[ERROR] Unknown Runner Operation: $($Matches[1])"
        }
    }
}

if ($LastExitCode -ne 0)
{
    throw "[ERROR] Test Failed"
}
