﻿# Powershell 2.0 には ConvertFrom-Json が無いため、代替となる関数を用意します。
Function ConvertFrom-Json20($JsonText)
{
    Add-Type -Assembly System.Web.Extensions
    $Serializer = New-Object System.Web.Script.Serialization.JavaScriptSerializer
    return $Serializer.DeserializeObject($JsonText)
}

# JSON ファイルを解析します。
Function ReadJson($Path)
{
    $Path = if ($Path -match "\.json$") { $Path } else { "$($Path).json" }
    $Data = Get-Content $path -Encoding UTF8
    return ConvertFrom-Json20 $Data
}

# データサイズを解析します。
Function DataSize($Str)
{
    if ($Str -match "^([0-9]+)\s*([KMG]?B)$")
    {
        $Value = [long]$Matches[1]
        if ($Matches[2] -eq "B")
        {
            return $Value
        }
        elseif ($Matches[2] -eq "KB")
        {
            return $Value * 1024
        }
        elseif ($Matches[2] -eq "MB")
        {
            return $Value * 1024 * 1024
        }
        elseif ($Matches[2] -eq "GB")
        {
            return $Value * 1024 * 1024 * 1024
        }
    }
    throw $Str
}

# SIGLO_ROOT からの相対パスを絶対パスにします。
# 加えて、ワイルドカードの解決、識別子の値への変換も行います。
Function ResolvePath($Pattern, $Build)
{
    $Pattern = $Pattern.Replace("%{Build}", $Build)

    Push-Location $SIGLO_ROOT

    $Results = @(Resolve-Path $Pattern)
    if ($Results.Count -ne 1)
    {
        throw "NotMatchSingleFile"
    }
    $Result = $Results[0]

    Pop-Location

    return $Result
}
