﻿# アプリケーションをアンインストールします。
Function UninstallApplicationTask($Target, $Application)
{
    # アプリケーションのインストール状態を確認します。
    $InstalledApplication = $Target.InstalledApplications |
        Where-Object Id -eq $Application.Id |
        Select-Object -First 1

    # アプリケーションがインストールされている場合はアンインストールします。
    if ($InstalledApplication -ne $NULL)
    {
        UninstallApplication $Target.Name $Application.Id $TRUE

        # アプリケーションのインストール状態を更新します。
        $Target.InstalledApplications.Remove($InstalledApplication) > $null
    }
}

# システムプログラムをアンインストールします。
Function UninstallSystemProgramTask($Target, $SystemProgram)
{
    # システムプログラムのインストール状態を確認します。
    $InstalledSystemProgram = $Target.InstalledSystemPrograms |
        Where-Object Id -eq $SystemProgram.Id |
        Select-Object -First 1

    # システムプログラムがインストールされている場合はアンインストールします。
    if ($InstalledSystemProgram -ne $NULL)
    {
        UninstallSystemProgram $Target.Name $SystemProgram.Id $TRUE

        # システムプログラムのインストール状態を更新します。
        $Target.InstalledSystemPrograms.Remove($InstalledSystemProgram) > $null
    }
}

# 指定された 1 つのコンテンツをアンインストールするタスクです。
Function UninstallSubTask($Target, $Value, $Contents)
{
    # 対象のコンテンツによって処理を分岐します。
    if ($Value.application)
    {
        $Application = $Contents.Applications[$Value.application]
        if ($Application -eq $NULL)
        {
            throw "Uninstall Failed: Unknown Application = $($Value.application)"
        }
        UninstallApplicationTask $Target $Application
    }
    elseif ($Value.system_data)
    {
        $SystemData = $Contents.SystemData[$Value.system_data]
        if ($SystemData -eq $NULL)
        {
            throw "Uninstall Failed: Unknown System Data = $($Value.system_data)"
        }
        UninstallSystemProgramTask $Target $SystemData
    }
    elseif ($Value.system_update_meta)
    {
        $SystemUpdateMeta = $Contents.SystemUpdateMeta[$Value.system_update_meta]
        if ($SystemUpdateMeta -eq $NULL)
        {
            throw "Uninstall Failed: Unknown System Update Meta = $($Value.system_update_meta)"
        }
        UninstallSystemProgramTask $Target $SystemUpdateMeta
    }
    else
    {
        throw "Uninstall Failed: Unspecified Content"
    }
}

# 指定されたコンテンツを全てアンインストールするタスクです。
Function UninstallTask($Target, $Values, $Contents)
{
    foreach ($Value in $Values)
    {
        UninstallSubTask $Target $Value $Contents
    }
}
