﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nnt/nntest.h>
#include <nn/os.h>
#include <nn/nn_Log.h>
#include <nn/lmem/lmem_Common.h>

#define ASSERT_NULL(p) ASSERT_TRUE(p == nullptr)
#define ASSERT_NOT_NULL(p) ASSERT_TRUE(p != nullptr)

const size_t ThreadStackSize = 16384;                                    // スレッドのスタックサイズ
const int MaxThreadCount = 8;                                           // 作成するスレッドの最大数

/**
 * @brief   スレッドに渡すユーザ定義の構造体です。
 */
struct CheckStruct
{
    nn::lmem::HeapHandle handle;    // ヒープハンドル
    nn::Bit64 fill;                 // スレッドごとに固有のフィル値
};

/**
 * @brief   ヒープ共通のテストフィクスチャです。
 */
class LMemThreadSafeTest : public testing::Test
{
protected:

    const size_t m_HeapSize;                // OS からもらうメモリプールのサイズ
    void* m_Heap;                       // メモリプールへのポインタ
    nn::lmem::HeapHandle m_HeapHandle;      // ヒープハンドル
    int m_CoreNumber[MaxThreadCount];       // 利用できる CPU コアの番号
    int m_MaxCoreCount;                     // 利用できる CPU コア数

    LMemThreadSafeTest() : m_HeapSize(nn::os::MemoryBlockUnitSize){}

    /**
     * @brief   共通の初期化処理です。
     */
    void InitializeCommmon();

    /**
     * @brief   スレッドの動作を開始します。
     */
    void StartThread(const int FunctionCount);

    /**
     * @brief   マルチスレッドによるテストを開始します。
     */
    void DoMultiThreadTest(nn::os::ThreadFunction* functions, const int FunctionCount);

    /**
     * @brief   マルチスレッドによるテストを開始します。
     * @details 各スレッドに CheckStruct 型の固有データを渡します。
     */
    void DoMultiThreadTestWithCheckStruct(nn::os::ThreadFunction* functions, const int FunctionCount);
};
