﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Log.h>

#if defined(NN_SDK_BUILD_DEBUG) || defined(NN_SDK_BUILD_DEVELOP)

// デバッグ時のみ有効
#define NN_TEST_MEM_DEBUG

#endif

#define ASSERT_NULL(p) ASSERT_TRUE(p == nullptr)
#define ASSERT_NOT_NULL(p) ASSERT_TRUE(p != nullptr)

/**
 * @brief       pAddress から size 分適当な値を代入します。
 * @param[in]   pAddress 開始アドレス
 * @param[in]   size    値を入れるサイズ
 */
bool WriteNumericalSequence(void* pAddress, size_t size);

/**
 * @brief       pAddress から size 分値を検査し、 WriteNumericalSequence で入れられた値と同じものかチェックします。
 * @param[in]   pAddress    開始アドレス
 * @param[in]   size        値を入れるサイズ
 * @return      WriteNumericalSequence() で入れられた値と同じものならば、true を、そうでないなら false を返します。
 */
bool HasNumericalSequence(void* pAddress, size_t size);

/**
 * @brief       pAddress から size 分値を検査し、 correctNum であるかどうかチェックします。
 * @param[in]   pAddress    開始アドレス
 * @param[in]   size        値を入れるサイズ
 * @param[in]   correctNum  比較対象の値
 * @return      num ならば、true を、そうでないなら false を返します。
 */
bool HasEqualNum(void* pAddress, size_t size, uint32_t correctNum);
