﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/nn_BitTypes.h>
#include <nn/nn_Result.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace jit { namespace testvm { // NOLINT(whitespace/braces)

class IJitCompileEnvironment;

class IJitEnvironment;

class IProtoJitLoader2;

class ITestVmJitCompileEnvironment;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IJitCompileEnvironment, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IJitCompileEnvironment)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetCodeAddress, (::nn::sf::Out<::std::uint64_t> pOut))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ShareRom, (::std::uint64_t tag, ::nn::sf::NativeHandle&& transferMemoryHandle, ::std::uint64_t size))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IJitCompileEnvironment)

        ::nn::Result GetCodeAddress(::nn::sf::Out<::std::uint64_t> pOut) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetCodeAddress, (pOut));
        }

        ::nn::Result ShareRom(::std::uint64_t tag, ::nn::sf::NativeHandle&& transferMemoryHandle, ::std::uint64_t size) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ShareRom, (tag, ::std::move(transferMemoryHandle), size));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IJitCompileEnvironment
    {
    public:
        nn::Result GetCodeAddress(nn::sf::Out<std::uint64_t> pOut) NN_NOEXCEPT;
        nn::Result ShareRom(std::uint64_t tag, nn::sf::NativeHandle&& transferMemoryHandle, std::uint64_t size) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result GetCodeAddress(nn::sf::Out<std::uint64_t> pOut) NN_NOEXCEPT;
    nn::Result ShareRom(std::uint64_t tag, nn::sf::NativeHandle&& transferMemoryHandle, std::uint64_t size) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::jit::testvm::IJitCompileEnvironment))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetCodeAddress, (::nn::sf::Out<::std::uint64_t> pOut))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetCodeAddress, (pOut));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ShareRom, (::std::uint64_t tag, ::nn::sf::NativeHandle&& transferMemoryHandle, ::std::uint64_t size))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ShareRom, (tag, ::std::move(transferMemoryHandle), size));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::jit::testvm::IJitCompileEnvironment>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::jit::testvm::IJitCompileEnvironment))

    // nn::Result GetCodeAddress(nn::sf::Out<std::uint64_t> pOut) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetCodeAddress)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOut, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOut))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetCodeAddress)

    // nn::Result ShareRom(std::uint64_t tag, nn::sf::NativeHandle&& transferMemoryHandle, std::uint64_t size) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ShareRom)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(10)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFO(transferMemoryHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS_END(1, (transferMemoryHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(tag, (::std::uint64_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(size, (::std::uint64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (tag, size))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(tag), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(transferMemoryHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(size)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ShareRom)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::jit::testvm::IJitCompileEnvironment, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::jit::testvm::IJitCompileEnvironment))

    // nn::Result GetCodeAddress(nn::sf::Out<std::uint64_t> pOut) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetCodeAddress, (::nn::sf::Out<::std::uint64_t> pOut))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetCodeAddress)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetCodeAddress)
    }

    // nn::Result ShareRom(std::uint64_t tag, nn::sf::NativeHandle&& transferMemoryHandle, std::uint64_t size) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ShareRom, (::std::uint64_t tag, ::nn::sf::NativeHandle&& transferMemoryHandle, ::std::uint64_t size))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ShareRom)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(tag)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(transferMemoryHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(size)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ShareRom)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::jit::testvm::IJitCompileEnvironment>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::jit::testvm::IJitCompileEnvironment))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetCodeAddress)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetCodeAddress)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ShareRom)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLE(transferMemoryHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ShareRom)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(tag),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_NATIVE_HANDLE(transferMemoryHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(size)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetCodeAddress)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ShareRom)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::jit::testvm::IJitCompileEnvironment))

namespace nn { namespace jit { namespace testvm { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IJitEnvironment, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IJitEnvironment)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateTestVmJitCompileEnvironment, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::jit::testvm::ITestVmJitCompileEnvironment>> pOut))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IJitEnvironment)

        ::nn::Result CreateTestVmJitCompileEnvironment(::nn::sf::Out<::nn::sf::SharedPointer<::nn::jit::testvm::ITestVmJitCompileEnvironment>> pOut) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateTestVmJitCompileEnvironment, (pOut));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IJitEnvironment
    {
    public:
        nn::Result CreateTestVmJitCompileEnvironment(nn::sf::Out<nn::sf::SharedPointer<nn::jit::testvm::ITestVmJitCompileEnvironment>> pOut) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result CreateTestVmJitCompileEnvironment(nn::sf::Out<nn::sf::SharedPointer<nn::jit::testvm::ITestVmJitCompileEnvironment>> pOut) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::jit::testvm::IJitEnvironment))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateTestVmJitCompileEnvironment, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::jit::testvm::ITestVmJitCompileEnvironment>> pOut))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateTestVmJitCompileEnvironment, (pOut));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::jit::testvm::IJitEnvironment>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::jit::testvm::IJitEnvironment))

    // nn::Result CreateTestVmJitCompileEnvironment(nn::sf::Out<nn::sf::SharedPointer<nn::jit::testvm::ITestVmJitCompileEnvironment>> pOut) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateTestVmJitCompileEnvironment)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(pOut, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (pOut))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateTestVmJitCompileEnvironment)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::jit::testvm::IJitEnvironment, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::jit::testvm::IJitEnvironment))

    // nn::Result CreateTestVmJitCompileEnvironment(nn::sf::Out<nn::sf::SharedPointer<nn::jit::testvm::ITestVmJitCompileEnvironment>> pOut) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateTestVmJitCompileEnvironment, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::jit::testvm::ITestVmJitCompileEnvironment>> pOut))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateTestVmJitCompileEnvironment)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateTestVmJitCompileEnvironment)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::jit::testvm::IJitEnvironment>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::jit::testvm::IJitEnvironment))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateTestVmJitCompileEnvironment)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::jit::testvm::ITestVmJitCompileEnvironment>), pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateTestVmJitCompileEnvironment)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(pOut, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateTestVmJitCompileEnvironment)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::jit::testvm::IJitEnvironment))

namespace nn { namespace jit { namespace testvm { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IProtoJitLoader2, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IProtoJitLoader2)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateJitEnvironment, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::jit::testvm::IJitEnvironment>> pOut, ::nn::sf::NativeHandle&& processHandle, ::nn::Bit64 processId, ::std::uint64_t bufferAddress, ::std::uint64_t bufferSize))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IProtoJitLoader2)

        ::nn::Result CreateJitEnvironment(::nn::sf::Out<::nn::sf::SharedPointer<::nn::jit::testvm::IJitEnvironment>> pOut, ::nn::sf::NativeHandle&& processHandle, ::nn::Bit64 processId, ::std::uint64_t bufferAddress, ::std::uint64_t bufferSize) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateJitEnvironment, (pOut, ::std::move(processHandle), processId, bufferAddress, bufferSize));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IProtoJitLoader2
    {
    public:
        nn::Result CreateJitEnvironment(nn::sf::Out<nn::sf::SharedPointer<nn::jit::testvm::IJitEnvironment>> pOut, nn::sf::NativeHandle&& processHandle, nn::Bit64 processId, std::uint64_t bufferAddress, std::uint64_t bufferSize) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result CreateJitEnvironment(nn::sf::Out<nn::sf::SharedPointer<nn::jit::testvm::IJitEnvironment>> pOut, nn::sf::NativeHandle&& processHandle, nn::Bit64 processId, std::uint64_t bufferAddress, std::uint64_t bufferSize) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::jit::testvm::IProtoJitLoader2))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateJitEnvironment, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::jit::testvm::IJitEnvironment>> pOut, ::nn::sf::NativeHandle&& processHandle, ::nn::Bit64 processId, ::std::uint64_t bufferAddress, ::std::uint64_t bufferSize))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateJitEnvironment, (pOut, ::std::move(processHandle), processId, bufferAddress, bufferSize));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::jit::testvm::IProtoJitLoader2>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::jit::testvm::IProtoJitLoader2))

    // nn::Result CreateJitEnvironment(nn::sf::Out<nn::sf::SharedPointer<nn::jit::testvm::IJitEnvironment>> pOut, nn::sf::NativeHandle&& processHandle, nn::Bit64 processId, std::uint64_t bufferAddress, std::uint64_t bufferSize) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateJitEnvironment)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(pOut, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (pOut))

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFO(processHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS_END(1, (processHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(processId, (::nn::Bit64), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(bufferAddress, (::std::uint64_t), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(bufferSize, (::std::uint64_t), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (processId, bufferAddress, bufferSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(processHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(processId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(bufferAddress), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(bufferSize)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateJitEnvironment)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::jit::testvm::IProtoJitLoader2, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::jit::testvm::IProtoJitLoader2))

    // nn::Result CreateJitEnvironment(nn::sf::Out<nn::sf::SharedPointer<nn::jit::testvm::IJitEnvironment>> pOut, nn::sf::NativeHandle&& processHandle, nn::Bit64 processId, std::uint64_t bufferAddress, std::uint64_t bufferSize) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateJitEnvironment, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::jit::testvm::IJitEnvironment>> pOut, ::nn::sf::NativeHandle&& processHandle, ::nn::Bit64 processId, ::std::uint64_t bufferAddress, ::std::uint64_t bufferSize))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateJitEnvironment)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(processHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(processId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(bufferAddress)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(bufferSize)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateJitEnvironment)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::jit::testvm::IProtoJitLoader2>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::jit::testvm::IProtoJitLoader2))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateJitEnvironment)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLE(processHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::jit::testvm::IJitEnvironment>), pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OVERWRITE_IN_PROCESS_ID(processId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateJitEnvironment)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(pOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_NATIVE_HANDLE(processHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(processId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(bufferAddress),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(bufferSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(pOut, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateJitEnvironment)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::jit::testvm::IProtoJitLoader2))

namespace nn { namespace jit { namespace testvm { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(ITestVmJitCompileEnvironment, (::nn::jit::testvm::IJitCompileEnvironment))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(ITestVmJitCompileEnvironment)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(SetupTestVmCompiler)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GenerateCode, (::nn::sf::Out<::std::uint64_t> pEntry, ::nn::sf::Out<::std::uint64_t> pCodeSize, ::nn::sf::Out<::std::uint32_t> pInstructionCount, ::std::int32_t pc))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(ITestVmJitCompileEnvironment)

        ::nn::Result SetupTestVmCompiler() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(SetupTestVmCompiler);
        }

        ::nn::Result GenerateCode(::nn::sf::Out<::std::uint64_t> pEntry, ::nn::sf::Out<::std::uint64_t> pCodeSize, ::nn::sf::Out<::std::uint32_t> pInstructionCount, ::std::int32_t pc) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GenerateCode, (pEntry, pCodeSize, pInstructionCount, pc));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class ITestVmJitCompileEnvironment : public ::nn::jit::testvm::IJitCompileEnvironment
    {
    public:
        nn::Result SetupTestVmCompiler() NN_NOEXCEPT;
        nn::Result GenerateCode(nn::sf::Out<std::uint64_t> pEntry, nn::sf::Out<std::uint64_t> pCodeSize, nn::sf::Out<std::uint32_t> pInstructionCount, std::int32_t pc) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result GetCodeAddress(nn::sf::Out<std::uint64_t> pOut) NN_NOEXCEPT;
    nn::Result ShareRom(std::uint64_t tag, nn::sf::NativeHandle&& transferMemoryHandle, std::uint64_t size) NN_NOEXCEPT;
    nn::Result SetupTestVmCompiler() NN_NOEXCEPT;
    nn::Result GenerateCode(nn::sf::Out<std::uint64_t> pEntry, nn::sf::Out<std::uint64_t> pCodeSize, nn::sf::Out<std::uint32_t> pInstructionCount, std::int32_t pc) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_WITH_BASE((::nn::jit::testvm::ITestVmJitCompileEnvironment), (::nn::jit::testvm::IJitCompileEnvironment))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(SetupTestVmCompiler)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(SetupTestVmCompiler);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GenerateCode, (::nn::sf::Out<::std::uint64_t> pEntry, ::nn::sf::Out<::std::uint64_t> pCodeSize, ::nn::sf::Out<::std::uint32_t> pInstructionCount, ::std::int32_t pc))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GenerateCode, (pEntry, pCodeSize, pInstructionCount, pc));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::jit::testvm::ITestVmJitCompileEnvironment>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_WITH_BASE((::nn::jit::testvm::ITestVmJitCompileEnvironment), (::nn::jit::testvm::IJitCompileEnvironment))

    // nn::Result SetupTestVmCompiler() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetupTestVmCompiler)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(100)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetupTestVmCompiler)

    // nn::Result GenerateCode(nn::sf::Out<std::uint64_t> pEntry, nn::sf::Out<std::uint64_t> pCodeSize, nn::sf::Out<std::uint32_t> pInstructionCount, std::int32_t pc) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GenerateCode)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(101)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(pc, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (pc))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pInstructionCount, (::std::uint32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pEntry, (::std::uint64_t), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pCodeSize, (::std::uint64_t), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(3, (pInstructionCount, pEntry, pCodeSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pEntry), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pCodeSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pInstructionCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pc)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GenerateCode)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::jit::testvm::ITestVmJitCompileEnvironment, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_WITH_BASE((::nn::jit::testvm::ITestVmJitCompileEnvironment), (::nn::jit::testvm::IJitCompileEnvironment))

    // nn::Result SetupTestVmCompiler() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(SetupTestVmCompiler)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetupTestVmCompiler)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetupTestVmCompiler)
    }

    // nn::Result GenerateCode(nn::sf::Out<std::uint64_t> pEntry, nn::sf::Out<std::uint64_t> pCodeSize, nn::sf::Out<std::uint32_t> pInstructionCount, std::int32_t pc) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GenerateCode, (::nn::sf::Out<::std::uint64_t> pEntry, ::nn::sf::Out<::std::uint64_t> pCodeSize, ::nn::sf::Out<::std::uint32_t> pInstructionCount, ::std::int32_t pc))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GenerateCode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pEntry)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pCodeSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pInstructionCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pc)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GenerateCode)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::jit::testvm::ITestVmJitCompileEnvironment>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_WITH_BASE((::nn::jit::testvm::ITestVmJitCompileEnvironment), (::nn::jit::testvm::IJitCompileEnvironment))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetupTestVmCompiler)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetupTestVmCompiler)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GenerateCode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GenerateCode)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pEntry),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pCodeSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pInstructionCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(pc)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetupTestVmCompiler)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GenerateCode)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END_WITH_BASE

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::jit::testvm::ITestVmJitCompileEnvironment))
