﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @examplesource{MemoryPool.h,PageSampleNvnTutorialLibrary}
 *
 * @brief
 *  This file defines a wrapper around the NVNmemoryPool
 *  object that keeps track of the memory allocated for the
 *  pool, the size of the pool, and the offset into the pool
 *  at which the next memory write could take place. This class
 *  also handles initializing the NVNmemoryPool and makes sure
 *  the memory alignment is handled properly.
 */

#pragma once

#include <nvn\nvn.h>
#include <atomic>

static const size_t g_MinimumPoolSize = NVN_MEMORY_POOL_STORAGE_GRANULARITY;

class MemoryPool
{
    public:
        MemoryPool();
        ~MemoryPool();

        void Init(void* pMemory, size_t size, int flags, NVNdevice* pDevice);
        void Shutdown();

        ptrdiff_t GetNewMemoryChunkOffset(size_t size, size_t alignment);
        NVNmemoryPool* GetMemoryPool();

    private:
        std::atomic<ptrdiff_t>      m_CurrentWriteOffset;
        NVNmemoryPool               m_MemoryPool;
        void*                       m_pMemory;
        size_t                      m_Size;
        int                         m_Flags;
};
