﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @examplesource{AssetFileLoadingHelper.h,PageSampleNvnTutorialLibrary}
 *
 * @brief
 *  This file defines a helper class used to load in asset files
 *  generated by Tutorial02. The asset file has three potential
 *  sections: compiled shaders, packaged textures, and model
 *  model data. The exact structure of the asset file can
 *  be seen in OutputFileHeaders.h.
 */

#pragma once

#include <nn/nn_Macro.h>
#include <nvn/nvn.h>
#include <nvnTool\nvnTool_GlslcInterface.h>
#include <vector>
#include "AssetFileDataHolder.h"

class TextureIDManager;

class AssetFileLoadingHelper
{
    public:
        AssetFileLoadingHelper(NVNdevice* pDevice, TextureIDManager* pTextureIDManager);
        ~AssetFileLoadingHelper();

        AssetFileDataHolder* LoadAssetFile(const char* pFilename);

        typedef void(*ReflectionBlockInfoFunction)(NVNshaderStageBits shaderStage, uint32_t bindingLocation, uint32_t blockSize, const std::string& blockName);
        typedef void(*ReflectionUniformInfoFunction)(NVNshaderStageBits shaderStage, uint32_t offset, uint32_t dataSize, const std::string& uniformName);
        typedef void(*AttributeReflectionInfoFunction)(NVNshaderStageBits shaderStage, int32_t bindingLocation, const std::string& attributeName);

        void LoadSpecializedShaders(
            const char** ppShaderSources,
            const std::vector<NVNshaderStage>& shaderStages,
            GLSLCspecializationBatch* specializationBatch,
            const char* shaderProgramName,
            int nameLength,
            ReflectionBlockInfoFunction blockFunction,
            ReflectionUniformInfoFunction uniformFunction,
            AttributeReflectionInfoFunction attributeFunction);

    private:
        void LoadShaders(const char* pShaderBlockHead);
        NVNProgramData* LoadShaderHeaders(const char* pShaderProgramHead);
        void CreateShaderProgram(std::vector<ShaderStageHeader>& shaderStageHeaders, NVNProgramData* pProgramData);

        void LoadModels(const char* pModelBlockHead);
        NVNModelData* LoadModelData(const char* pModelHead);

        void LoadTextures(const char* pTextureBlockHead);
        NVNTextureData* LoadTextureData(char* pTextureDataHead);

        AssetFileDataHolder*    m_pDataHolder;

        NVNdevice*              m_pDevice;
        NVNbufferBuilder        m_BufferBuilder;
        NVNtextureBuilder       m_TextureBuilder;
        NVNsamplerBuilder       m_SamplerBuilder;
        TextureIDManager*       m_pTextureIDManager;

        char*                   m_pFileHead;
        int64_t                 m_FileSize;

};
