﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nfp.h>
#include "testNfp_Config.h"

namespace nnt { namespace nfp { namespace wrapper {
    //==================================================
    // API実行時のログ設定
    //==================================================
    enum LogMode
    {
        LogMode_None = 0,
        LogMode_Aging = 1 << 0,
    };

    void SetApiCallLoggingMode(const uint32_t mode) NN_NOEXCEPT;

    //==================================================
    // NFPライブラリ実行用のラッパー関数
    //==================================================
    nn::Result Initialize() NN_NOEXCEPT;
    void Finalize() NN_NOEXCEPT;
    nn::Result ListDevices(nn::nfp::DeviceHandle* pOutBuffer, int* pOutCount, int bufferCount) NN_NOEXCEPT;
    nn::Result StartDetection(const nn::nfp::DeviceHandle& deviceHandle) NN_NOEXCEPT;
    nn::Result StartDetection() NN_NOEXCEPT;
    nn::Result StopDetection(const nn::nfp::DeviceHandle& deviceHandle) NN_NOEXCEPT;
    nn::Result StopDetection() NN_NOEXCEPT;
    nn::Result Mount(const nn::nfp::DeviceHandle& deviceHandle, nn::nfp::ModelType modelType) NN_NOEXCEPT;
    nn::Result Mount(const nn::nfp::DeviceHandle& deviceHandle, nn::nfp::ModelType modelType, nn::nfp::MountTarget mountTarget) NN_NOEXCEPT;
    nn::Result Mount() NN_NOEXCEPT;
    nn::Result MountRom() NN_NOEXCEPT;
    nn::Result Unmount(const nn::nfp::DeviceHandle& deviceHandle) NN_NOEXCEPT;
    nn::Result Unmount() NN_NOEXCEPT;
    nn::Result OpenApplicationArea(const nn::nfp::DeviceHandle& deviceHandle, nn::Bit32 accessId) NN_NOEXCEPT;
    nn::Result OpenApplicationArea(nn::Bit32 accessId) NN_NOEXCEPT;
    nn::Result CreateApplicationArea(const nn::nfp::DeviceHandle& deviceHandle, const nn::nfp::ApplicationAreaCreateInfo& createInfo) NN_NOEXCEPT;
    nn::Result CreateApplicationArea(const nn::nfp::ApplicationAreaCreateInfo& createInfo) NN_NOEXCEPT;
    nn::Result GetApplicationArea(void* pOutBuffer, const nn::nfp::DeviceHandle& deviceHandle, size_t bufferSize) NN_NOEXCEPT;
    nn::Result GetApplicationArea(void* pOutBuffer, size_t bufferSize) NN_NOEXCEPT;
    nn::Result GetApplicationArea(void* pOutBuffer, size_t* pOutSize, const nn::nfp::DeviceHandle& deviceHandle, size_t bufferSize) NN_NOEXCEPT;
    nn::Result GetApplicationArea(void* pOutBuffer, size_t* pOutSize, size_t bufferSize) NN_NOEXCEPT;
    nn::Result SetApplicationArea(const nn::nfp::DeviceHandle& deviceHandle, const void* pData, size_t dataSize) NN_NOEXCEPT;
    nn::Result SetApplicationArea(const void* pData, size_t dataSize) NN_NOEXCEPT;
    nn::Result SetApplicationArea(const void* pData, size_t dataSize, nn::nfp::TagId tagId) NN_NOEXCEPT;
    nn::Result RecreateApplicationArea(const nn::nfp::DeviceHandle& deviceHandle, const nn::nfp::ApplicationAreaCreateInfo& createInfo) NN_NOEXCEPT;
    nn::Result RecreateApplicationArea(const nn::nfp::ApplicationAreaCreateInfo& createInfo) NN_NOEXCEPT;
    nn::Result Flush(const nn::nfp::DeviceHandle& deviceHandle) NN_NOEXCEPT;
    nn::Result Flush() NN_NOEXCEPT;
    nn::Result Restore(const nn::nfp::DeviceHandle& deviceHandle) NN_NOEXCEPT;
    nn::Result Restore() NN_NOEXCEPT;
    nn::Result GetTagInfo(nn::nfp::TagInfo* pOutTagInfo, const nn::nfp::DeviceHandle& deviceHandle) NN_NOEXCEPT;
    nn::Result GetTagInfo(nn::nfp::TagInfo* pOutTagInfo) NN_NOEXCEPT;
    nn::Result GetRegisterInfo(nn::nfp::RegisterInfo* pOutRegisterInfo, const nn::nfp::DeviceHandle& deviceHandle) NN_NOEXCEPT;
    nn::Result GetRegisterInfo(nn::nfp::RegisterInfo* pOutRegisterInfo) NN_NOEXCEPT;
    nn::Result GetRegisterInfo(nn::nfp::RegisterInfoPrivate* pOutRegisterInfo, const nn::nfp::DeviceHandle& deviceHandle) NN_NOEXCEPT;
    nn::Result GetRegisterInfo(nn::nfp::RegisterInfoPrivate* pOutRegisterInfo) NN_NOEXCEPT;
    nn::Result GetCommonInfo(nn::nfp::CommonInfo* pOutCommonInfo, const nn::nfp::DeviceHandle& deviceHandle) NN_NOEXCEPT;
    nn::Result GetCommonInfo(nn::nfp::CommonInfo* pOutCommonInfo) NN_NOEXCEPT;
    nn::Result GetModelInfo(nn::nfp::ModelInfo* pOutModelInfo, const nn::nfp::DeviceHandle& deviceHandle) NN_NOEXCEPT;
    nn::Result GetModelInfo(nn::nfp::ModelInfo* pOutModelInfo) NN_NOEXCEPT;
    nn::Result AttachActivateEvent(nn::os::SystemEventType* pEvent, const nn::nfp::DeviceHandle& deviceHandle) NN_NOEXCEPT;
    nn::Result AttachActivateEvent(nn::os::SystemEventType* pEvent) NN_NOEXCEPT;
    nn::Result AttachDeactivateEvent(nn::os::SystemEventType* pEvent, const nn::nfp::DeviceHandle& deviceHandle) NN_NOEXCEPT;
    nn::Result AttachDeactivateEvent(nn::os::SystemEventType* pEvent) NN_NOEXCEPT;
    nn::Result AttachAvailabilityChangeEvent(nn::os::SystemEventType* pEvent) NN_NOEXCEPT;
    nn::nfp::State GetState() NN_NOEXCEPT;
    nn::nfp::DeviceState GetDeviceState(const nn::nfp::DeviceHandle& deviceHandle) NN_NOEXCEPT;
    nn::nfp::DeviceState GetDeviceState() NN_NOEXCEPT;
    nn::Result GetAll(nn::nfp::NfpData* pOutNfpData, const nn::nfp::DeviceHandle& deviceHandle) NN_NOEXCEPT;
    nn::Result GetAll(nn::nfp::NfpData* pOutNfpData) NN_NOEXCEPT;
    nn::Result SetAll(const nn::nfp::DeviceHandle& deviceHandle, const nn::nfp::NfpData& nfpData) NN_NOEXCEPT;
    nn::Result SetAll(const nn::nfp::NfpData& nfpData) NN_NOEXCEPT;
    nn::Result FlushDebug(const nn::nfp::DeviceHandle& deviceHandle) NN_NOEXCEPT;
    nn::Result FlushDebug() NN_NOEXCEPT;
    nn::Result BreakTag(const nn::nfp::DeviceHandle& deviceHandle, nn::nfp::BreakType breakType) NN_NOEXCEPT;
    nn::Result BreakTag(nn::nfp::BreakType breakType) NN_NOEXCEPT;
    nn::Result InitializeSystem() NN_NOEXCEPT;
    void FinalizeSystem() NN_NOEXCEPT;
    nn::Result InitializeDebug() NN_NOEXCEPT;
    void FinalizeDebug() NN_NOEXCEPT;
    nn::Result Format(const nn::nfp::DeviceHandle& deviceHandle) NN_NOEXCEPT;
    nn::Result Format() NN_NOEXCEPT;
    nn::Result Format(const nn::Bit8* pDefaultData, int32_t defaultDataSize) NN_NOEXCEPT;
    nn::Result GetAdminInfo(nn::nfp::AdminInfo* pOutAdminInfo, const nn::nfp::DeviceHandle& deviceHandle) NN_NOEXCEPT;
    nn::Result GetAdminInfo(nn::nfp::AdminInfo* pOutAdminInfo) NN_NOEXCEPT;
    nn::Result SetRegisterInfo(const nn::nfp::DeviceHandle& deviceHandle, const nn::nfp::RegisterInfoPrivate& regInfo) NN_NOEXCEPT;
    nn::Result SetRegisterInfo(const nn::nfp::RegisterInfoPrivate& regInfo) NN_NOEXCEPT;
    nn::Result DeleteRegisterInfo(const nn::nfp::DeviceHandle& deviceHandle) NN_NOEXCEPT;
    nn::Result DeleteRegisterInfo() NN_NOEXCEPT;
    nn::Result DeleteApplicationArea(const nn::nfp::DeviceHandle& deviceHandle) NN_NOEXCEPT;
    nn::Result DeleteApplicationArea() NN_NOEXCEPT;
    nn::Result ExistsApplicationArea(bool *pOutValue, const nn::nfp::DeviceHandle& deviceHandle) NN_NOEXCEPT;
    nn::Result ExistsApplicationArea(bool *pOutValue) NN_NOEXCEPT;
    nn::Result StartNicknameAndOwnerSettings(nn::nfp::DeviceHandle* pOutDeviceHandle, bool* pOutIsRegistered, nn::nfp::RegisterInfo* pOutRegisterInfo, const nn::nfp::AmiiboSettingsStartParam& startParam, const nn::nfp::TagInfo& tagInfo, const nn::nfp::RegisterInfo& registerInfo) NN_NOEXCEPT;
    nn::Result StartNicknameAndOwnerSettings(nn::nfp::DeviceHandle* pOutDeviceHandle, bool* pOutIsRegistered, nn::nfp::RegisterInfo* pOutRegisterInfo, const nn::nfp::AmiiboSettingsStartParam& startParam, const nn::nfp::TagInfo& tagInfo) NN_NOEXCEPT;
    nn::Result StartGameDataEraser(nn::nfp::DeviceHandle* pOutDeviceHandle, const nn::nfp::AmiiboSettingsStartParam& startParam, const nn::nfp::TagInfo& tagInfo) NN_NOEXCEPT;
    nn::Result StartRestorer(nn::nfp::DeviceHandle* pOutDeviceHandle, const nn::nfp::AmiiboSettingsStartParam& startParam, const nn::nfp::TagInfo& tagInfo) NN_NOEXCEPT;
    nn::Result StartNicknameAndOwnerSettings(nn::nfp::TagInfo* pOutTagInfo, nn::nfp::DeviceHandle* pOutDeviceHandle, bool* pOutIsRegistered, nn::nfp::RegisterInfo* pOutRegisterInfo, const nn::nfp::AmiiboSettingsStartParam& startParam) NN_NOEXCEPT;
    nn::Result StartGameDataEraser(nn::nfp::TagInfo* pOutTagInfo, nn::nfp::DeviceHandle* pOutDeviceHandle, const nn::nfp::AmiiboSettingsStartParam& startParam) NN_NOEXCEPT;
    nn::Result StartRestorer(nn::nfp::TagInfo* pOutTagInfo, nn::nfp::DeviceHandle* pOutDeviceHandle, const nn::nfp::AmiiboSettingsStartParam& startParam) NN_NOEXCEPT;
    nn::Result StartFormatter(nn::nfp::TagInfo* pOutTagInfo, nn::nfp::DeviceHandle* pOutDeviceHandle, const nn::nfp::AmiiboSettingsStartParam& startParam) NN_NOEXCEPT;

#if !defined(NNT_NFP_PLATFORM_NX) // NX には別の amiibo 設定起動 I/F が用意されました。
    bool StartAmiiboSettings( nn::nfp::Parameter* pParameter ) NN_NOEXCEPT;
    bool IsAmiiboSettingsAvailable() NN_NOEXCEPT;
#endif // !defined(NNT_NFP_PLATFORM_NX)

#if !defined(NNT_NFP_PLATFORM_NX)
    nn::Result DeleteSystemSaveData() NN_NOEXCEPT;
    nn::Result WriteAllBackupSaveData(const void* pDataBuf, unsigned int writeSize) NN_NOEXCEPT;
    nn::Result InitializeRegisterInfoSet( nn::nfp::RegisterInfoPrivate* pRegInfo ) NN_NOEXCEPT;
    unsigned int GetBackupSaveDataSize() NN_NOEXCEPT;
    nn::Result ReadAllBackupSaveData(void* pDataBuf, unsigned int bufSize) NN_NOEXCEPT;
    nn::Result GetBackupHeaderFromMemory(nn::nfp::BackupHeaderInfo* pHeaderInfo,
                                             const void* pBackupData,
                                             unsigned int backupDataSize ) NN_NOEXCEPT;
    nn::Result GetBackupEntryFromMemory( nn::nfp::BackupEntryInfo* pEntryInfo,
                                         unsigned short entryIndex,
                                         const void* pBackupData,
                                         unsigned int backupDataSize ) NN_NOEXCEPT;
#else
    nn::Result ReadBackupData(void* pOutBuffer, size_t* pOutSize, size_t bufferSize) NN_NOEXCEPT;
    nn::Result WriteBackupData(const void* pData, size_t dataSize) NN_NOEXCEPT;
#endif // !defined(NNT_NFP_PLATFORM_NX)
    nn::Result GetNpadId(nn::hid::NpadIdType* pOutNpadId, const nn::nfp::DeviceHandle& deviceHandle) NN_NOEXCEPT;
    nn::Result GetNpadId(nn::hid::NpadIdType* pOutNpadId) NN_NOEXCEPT;
    void SetErrorVisible(bool visible) NN_NOEXCEPT;
    bool IsErrorVisible() NN_NOEXCEPT;
}}} // end of namespace nnt::nfp::wrapper
