﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/lcs.h>
#include <nnt/lcs/testLcs_TestApplications.h>

namespace nnt { namespace lcs
{
    //! ホストのデフォルトのユーザー名です。
    const char DefaultHostUserName[] = "LcsIntegrationStandaloneTest_Host";

    //! クライアントのデフォルトのユーザー名です。
    const char DefaultClientUserName[] = "LcsIntegrationStandaloneTest_Client";

    //! 最大長のユーザー名です。
    const char LongestUserName[] =
        "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz"
        "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz"
        "0123";

    /**
     * テスト開始時に 1 度だけ実行する初期化処理です。
     * @param[in]   sceneId         シーン識別子です。
     */
    void Setup(uint16_t sceneId) NN_NOEXCEPT;

    /**
     * LCS ライブラリの初期化に使用する nn::lcs::Config を生成します。
     * @param[in]   name            ユーザー名です。
     * @return      生成された nn::lcs::Config です。
     */
    nn::lcs::Config CreateConfig(const char* name) NN_NOEXCEPT;

    /**
     * LCS ライブラリの初期化に使用する nn::lcs::Config を生成します。
     * @return      生成された nn::lcs::Config です。
     */
    nn::lcs::Config CreateDefaultHostConfig() NN_NOEXCEPT;

    /**
     * LCS ライブラリの初期化に使用する nn::lcs::Config を生成します。
     * @return      生成された nn::lcs::Config です。
     */
    nn::lcs::Config CreateDefaultClientConfig() NN_NOEXCEPT;

    /**
     * @brief       指定されたアプリケーションを配布するためのセッション設定を生成します。
     * @param[in]   nodeCountMax            接続可能な端末の最大数です。
     * @param[in]   applicationId           配信対象のアプリケーションです。
     * @return      生成されたセッション設定です。
     */
    nn::lcs::SessionSettings CreateSessionSettings(
        int nodeCountMax, nn::ncm::ApplicationId applicationId) NN_NOEXCEPT;

    /**
     * @brief       指定されたアプリケーションを配布するためのセッション設定を生成します。
     * @param[in]   nodeCountMax            接続可能な端末の最大数です。
     * @param[in]   applicationId           配信対象のアプリケーションです。
     * @return      生成されたセッション設定です。
     */
    nn::lcs::SessionSettings CreateSessionSettings(
        int nodeCountMax, uint64_t applicationId) NN_NOEXCEPT;

}} // namespace nnt::lcs
