﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/lcs.h>

namespace nnt { namespace lcs
{
    /**
     * @brief       セッションコンテキストを保存します。
     * @param[in]   context             保存するセッションコンテキストです。
     * @return      処理の結果です。
     */
    nn::Result SaveSessionContext(const nn::lcs::SessionContext& context) NN_NOEXCEPT;

    /**
     * @brief       セッションコンテキストを読み込みます。
     * @param[out]  pOutContext         セッションコンテキストの出力先です。
     * @return      処理の結果です。
     */
    nn::Result LoadSessionContext(nn::lcs::SessionContext* pOutContext) NN_NOEXCEPT;

}} // namespace nnt::lcs
