﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/htcs.h>
#include <nn/os.h>

namespace nnt { namespace htcs { namespace util {
    void Connect(int socket, nn::htcs::SockAddrHtcs* pSockAddrHtcs);

    void ConnectToAnyHost(int socket, nn::htcs::HtcsPortName* pHtcsPortName);

    void ConnectToTestServer(int socket);

    void Echo(int socket, nn::htcs::ssize_t size, uint8_t* sendBuffer, uint8_t* recvBuffer, int recvFlag = 0);

    bool Recv(int socket, nn::htcs::ssize_t size, uint8_t* recvBuffer, int flag = 0);

    bool Send(int socket, nn::htcs::ssize_t size, uint8_t* sendBuffer);
}}}
