﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/lmem/lmem_ExpHeap.h>

namespace nnt {
namespace gfx {

/**
* @brief ファイルシステム
*
* @details
*/
class NntGfxFileSystem
{
public:
    /**
     * @brief 唯一のインスタンスを取得
     *
     * @return     インスタンス
    */
    static NntGfxFileSystem& GetInstance();

    /**
     * @brief ヒープを設定
     *
     * @param[in]  pHeapHandle 設定するヒープハンドル
    */
    virtual void SetHeap( nn::lmem::HeapHandle pHeapHandle );

    /**
     * @brief ファイル読み込み
     *
     * @param[out] ppData       読み込むデータの格納先
     * @param[out] pSize        データサイズ
     * @param[in]  pPath        読み込み先ファイルパス
     * @param[in]  alignment    アライメント
    */
    virtual bool Load( uint8_t** ppDest, size_t* pSize, const char* pPath, int alignment=4 );

    /**
     * @brief ファイルから読み込んだデータの破棄
     *
     * @param[in]  pData  データ
    */
    virtual void ReleaseData ( uint8_t* pData );

    /**
     * @brief ファイル書き込み
     *
     * @param[out] ppData 書き込むデータ
     * @param[out] pSize  データサイズ
     * @param[in]  pPath  出力先ファイルパス
    */
    virtual bool Write( const uint8_t* pData, size_t size, const char* pPath );

protected:

    nn::lmem::HeapHandle      m_HeapHandle; //!< 拡張ヒープ
};

}
}
