﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nnt { namespace fs { namespace util {
/**
* 以下の成果物を元に Tests/Fs/Scripts/Performance/output_testFs_util_storagePerformance.bat が自動生成しました。
*
*   https://devsedci01.nintendo.co.jp/TeamCity/viewType.html?buildTypeId=SigloSdk_Nx_Public_TestModuleSdevFs&tab=buildTypeHistoryList
*   2018/02/14 4:37:17
*/

static const size_t AccessPatternNum   = 2;
static const size_t ChunkSizeNum       = 13;

struct StorageSpeedSample
{
    const char* storageTypeName;
    double data[AccessPatternNum][ChunkSizeNum];
};

/**
* @brief ストレージ・チャンクサイズ・アクセスパターン別の Release ビルドでのサンプル速度
*/
static const StorageSpeedSample StorageSpeedSampleTable[] =
{
    {
        "RomRead_NANDFaster",
        {
            // Seq
            {  8.091,  14.490,  20.248,  26.732,  32.734,  51.330,  73.458,  89.075, 100.914,  97.252, 120.590, 131.179, 138.049},
            // Rand
            {  3.514,   5.097,   8.342,  14.623,  25.062,  40.777,  59.903,  75.977,  89.692,  91.225, 105.913, 117.269, 132.855},
        }
    },
    {
        "RomReadUnaligned_NANDFaster",
        {
            // Seq
            {  9.023,  15.987,  22.214,  29.115,  34.492,  51.620,  73.538,  89.700, 100.520,  97.292, 120.998, 131.490, 136.780},
            // Rand
            {  3.322,   5.071,   8.325,  14.629,  25.156,  40.970,  59.838,  76.554,  89.602,  91.322, 105.156, 119.721, 131.090},
        }
    },
    {
        "RomRead_NANDSlower",
        {
            // Seq
            {  3.663,   4.939,   5.618,   6.218,   6.425,   9.346,  12.324,  14.283,  15.747,  16.712,  14.615,  15.489,  15.854},
            // Rand
            {  0.210,   0.258,   0.424,   0.776,   1.479,   2.788,   4.937,   7.804,  11.353,  14.628,  13.196,  14.560,  15.525},
        }
    },
    {
        "RomReadUnaligned_NANDSlower",
        {
            // Seq
            {  3.825,   5.132,   5.689,   6.200,   6.406,   9.349,  12.423,  14.367,  15.827,  16.737,  14.619,  15.482,  15.860},
            // Rand
            {  0.195,   0.258,   0.421,   0.776,   1.479,   2.791,   4.945,   7.825,  11.354,  14.636,  13.287,  14.651,  15.481},
        }
    },
    {
        "RomRead_NANDOff",
        {
            // Seq
            {  6.752,  10.927,  14.510,  18.707,  22.478,  36.361,  53.418,  66.530,  70.261,  75.282,  90.775,  89.408,  97.458},
            // Rand
            {  2.236,   3.305,   5.475,   9.979,  17.547,  29.223,  43.674,  52.582,  59.850,  70.164,  80.372,  89.066,  98.566},
        }
    },
    {
        "RomReadUnaligned_NANDOff",
        {
            // Seq
            {  7.626,  12.356,  16.286,  19.921,  22.672,  36.311,  53.318,  67.003,  69.638,  75.339,  90.150,  89.378,  98.689},
            // Rand
            {  2.140,   3.387,   5.679,  10.124,  18.120,  30.153,  44.202,  53.794,  60.317,  70.517,  81.548,  89.378,  98.850},
        }
    },
    {
        "RomRead_GC50",
        {
            // Seq
            {  4.859,   6.202,   7.258,   8.152,   8.591,  13.693,  19.613,  25.142,  29.185,  31.006,  32.877,  34.518,  35.562},
            // Rand
            {  0.820,   1.254,   2.171,   3.901,   6.938,  11.470,  16.598,  19.843,  25.344,  29.240,  29.987,  32.420,  34.581},
        }
    },
    {
        "RomReadUnaligned_GC50",
        {
            // Seq
            {  5.287,   6.697,   7.664,   8.292,   8.584,  13.827,  19.613,  25.134,  29.270,  31.257,  32.891,  34.601,  35.562},
            // Rand
            {  0.760,   1.265,   2.166,   3.897,   7.016,  11.522,  16.631,  19.945,  25.360,  29.533,  30.278,  32.634,  34.311},
        }
    },
    {
        "RomRead_GC25",
        {
            // Seq
            {  4.241,   5.400,   6.260,   6.785,   7.146,  10.418,  13.422,  15.595,  17.190,  18.013,  18.411,  18.867,  19.103},
            // Rand
            {  0.680,   1.032,   1.769,   3.099,   5.262,   8.188,  11.113,  12.753,  15.271,  16.944,  17.227,  18.088,  18.748},
        }
    },
    {
        "RomReadUnaligned_GC25",
        {
            // Seq
            {  4.603,   5.759,   6.528,   6.933,   7.259,  10.420,  13.468,  15.682,  17.242,  18.047,  18.427,  18.851,  19.123},
            // Rand
            {  0.627,   1.034,   1.763,   3.090,   5.276,   8.205,  11.112,  12.807,  15.279,  17.058,  17.312,  18.208,  18.614},
        }
    },
    {
        "RomRead_SdCard",
        {
            // Seq
            {  4.528,   5.930,   7.134,   8.069,   8.435,  11.648,  14.680,  16.319,  17.481,  18.013,  18.960,  19.747,  20.205},
            // Rand
            {  1.017,   1.311,   2.113,   3.617,   5.980,   9.135,  12.194,  14.532,  16.334,  17.460,  18.275,  18.996,  19.923},
        }
    },
    {
        "RomReadUnaligned_SdCard",
        {
            // Seq
            {  5.056,   6.566,   7.572,   8.202,   8.565,  11.843,  14.812,  16.456,  17.509,  18.081,  18.989,  19.758,  20.204},
            // Rand
            {  0.948,   1.308,   2.110,   3.615,   6.006,   9.148,  12.191,  14.551,  16.341,  17.503,  18.293,  19.145,  19.863},
        }
    },
    {
        "SaveDataReadOff",
        {
            // Seq
            {  8.006,  13.982,  20.441,  26.722,  32.287,  51.725,  74.510,  94.568, 108.974, 103.899, 104.722, 108.415, 107.679},
            // Rand
            {  3.620,   5.148,   8.657,  15.885,  30.888,  49.013,  68.821,  88.421, 103.315,  99.975, 104.876, 105.622, 104.888},
        }
    },
    {
        "SaveDataReadUnalignedOff",
        {
            // Seq
            {  8.256,  13.842,  20.035,  27.358,  32.104,  50.698,  73.038,  94.359, 107.654, 111.629, 105.800, 105.741, 109.501},
            // Rand
            {  3.693,   4.963,   8.230,  13.968,  25.241,  42.023,  62.273,  81.463,  98.842,  99.476, 102.874, 108.223, 107.142},
        }
    },
    {
        "BisFsRead",
        {
            // Seq
            {  8.488,  14.804,  23.685,  32.936,  42.783,  64.098,  99.276, 132.605, 159.748, 180.327, 180.773, 180.960, 180.685},
            // Rand
            {  4.164,   6.495,  11.387,  21.873,  42.248,  63.558,  98.692, 132.836, 160.580, 178.887, 178.720, 180.408, 180.316},
        }
    },
    {
        "SdCardRead",
        {
            // Seq
            {  5.231,   7.291,   8.585,   9.861,  10.691,  14.415,  17.440,  19.427,  20.613,  21.252,  21.311,  21.333,  21.361},
            // Rand
            {  1.195,   1.568,   2.671,   5.212,  10.382,  14.247,  16.971,  19.021,  20.327,  21.090,  21.185,  21.253,  21.276},
        }
    },
    {
        "SaveDataReadSlower",
        {
            // Seq
            {  8.149,  13.750,  19.756,  25.787,  30.758,  51.976,  74.359,  94.433, 107.051, 107.303, 105.206, 107.638, 109.362},
            // Rand
            {  3.039,   4.203,   6.804,  12.518,  23.730,  42.118,  61.990,  83.169, 100.625, 103.903, 103.890, 104.689, 107.763},
        }
    },
    {
        "CacheStorageReadOff",
        {
            // Seq
            {  5.043,   7.209,   8.372,   9.313,   9.827,  13.477,  16.161,  17.949,  18.931,  19.522,  19.545,  19.578,  19.622},
            // Rand
            {  1.388,   1.762,   2.780,   4.907,   9.264,  13.056,  15.531,  17.558,  18.699,  19.342,  19.451,  19.492,  19.546},
        }
    },
    {
        "CacheStorageReadSlower",
        {
            // Seq
            {  4.969,   6.598,   7.792,   8.525,   9.016,  12.493,  14.807,  16.644,  17.597,  18.343,  18.324,  18.367,  18.346},
            // Rand
            {  0.251,   0.297,   0.457,   0.837,   1.607,   3.042,   5.436,   8.661,  12.322,  15.519,  17.009,  17.795,  18.344},
        }
    },
    {
        "TemporaryStorageReadOff",
        {
            // Seq
            {  8.349,  14.014,  20.803,  27.817,  33.957,  57.166,  81.257, 100.335, 115.366, 113.537, 112.393, 113.396, 117.944},
            // Rand
            {  3.929,   5.650,   9.138,  17.197,  33.264,  55.602,  75.895,  95.406, 109.721, 107.004, 110.279, 112.023, 113.372},
        }
    },
    {
        "TemporaryStorageReadSlower",
        {
            // Seq
            {  8.100,  13.704,  19.786,  26.060,  31.127,  53.553,  77.319,  96.672, 111.163, 110.676, 108.812, 109.323, 112.441},
            // Rand
            {  3.116,   4.299,   6.930,  12.967,  24.883,  43.379,  63.539,  85.018, 101.917, 106.850, 107.379, 108.286, 111.611},
        }
    },
    {
        "RomRead_NANDOffRealtime",
        {
            // Seq
            {  8.004,  12.456,  15.823,  19.368,  23.348,  37.381,  54.116,  68.025,  70.771,  75.442,  90.506,  89.546,  98.675},
            // Rand
            {  2.324,   3.423,   5.720,  10.299,  18.190,  30.066,  44.206,  53.075,  59.799,  69.981,  81.034,  88.352,  98.675},
        }
    },
    {
        "RomReadUnaligned_NANDOffRealtime",
        {
            // Seq
            {  9.024,  14.001,  17.823,  21.199,  23.343,  37.210,  53.868,  68.057,  69.940,  75.454,  90.410,  89.416,  99.008},
            // Rand
            {  2.220,   3.473,   5.832,  10.500,  18.600,  30.394,  45.143,  54.395,  60.407,  70.516,  81.675,  90.379,  99.713},
        }
    },
    {
        "RomRead_NANDOffLow",
        {
            // Seq
            {  6.841,  10.945,  14.542,  18.580,  22.628,  36.351,  53.312,  53.055,  59.039,  62.310,  63.172,  63.460,  63.797},
            // Rand
            {  2.244,   3.289,   5.602,  10.035,  17.829,  29.510,  43.887,  43.923,  53.038,  58.781,  61.239,  62.460,  63.783},
        }
    },
    {
        "RomReadUnaligned_NANDOffLow",
        {
            // Seq
            {  7.438,  12.434,  16.343,  20.164,  22.796,  36.487,  53.303,  53.222,  59.583,  62.829,  63.750,  63.728,  64.027},
            // Rand
            {  2.108,   3.359,   5.560,   9.999,  18.143,  30.034,  44.055,  44.841,  53.853,  59.617,  62.070,  63.460,  64.468},
        }
    },
    {
        "RomRead_NANDOffBackground",
        {
            // Seq
            {  6.348,  10.671,  14.154,  18.455,  22.247,  35.803,  51.670,  51.822,  57.142,  60.592,  60.985,  61.148,  61.765},
            // Rand
            {  2.190,   3.265,   5.454,   9.800,  17.512,  28.649,  41.838,  42.770,  51.434,  56.631,  59.232,  60.085,  60.979},
        }
    },
    {
        "RomReadUnaligned_NANDOffBackground",
        {
            // Seq
            {  7.549,  12.143,  15.130,  19.698,  22.169,  35.458,  51.528,  52.791,  58.545,  61.943,  62.132,  62.036,  62.695},
            // Rand
            {  2.112,   3.356,   5.573,  10.080,  17.956,  29.679,  43.635,  44.066,  52.800,  58.096,  60.491,  61.929,  62.671},
        }
    },
    {
        "SaveDataReadOffRealtime",
        {
            // Seq
            { 11.464,  17.215,  24.022,  28.772,  34.814,  54.743,  81.257,  97.398, 113.821, 110.638, 107.953, 108.442, 113.385},
            // Rand
            {  4.001,   5.785,   9.276,  17.482,  32.988,  55.237,  74.597,  93.003, 107.916, 100.841, 105.482, 110.314, 108.835},
        }
    },
    {
        "SaveDataReadOffLow",
        {
            // Seq
            {  8.257,  14.068,  20.394,  27.156,  32.295,  52.747,  74.859,  95.196,  99.264, 100.044,  99.203,  99.054,  98.317},
            // Rand
            {  3.753,   5.351,   8.687,  16.669,  31.652,  50.012,  68.794,  87.995,  94.495,  96.457,  99.397,  99.372,  99.439},
        }
    },
    {
        "SaveDataReadOffBackground",
        {
            // Seq
            {  7.976,  13.315,  20.141,  26.544,  30.615,  53.292,  75.127,  94.384,  97.225,  98.977,  98.858,  97.283,  97.397},
            // Rand
            {  3.583,   5.196,   8.487,  16.184,  30.688,  50.113,  68.836,  85.959,  93.574,  96.465,  96.426,  97.526,  97.336},
        }
    },
};
}}}
