﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <string>
#include <cstddef>
#include <cstdint>

#include <nnt/codecUtil/testCodec_CoreSelector.h>
#include <nnt/codecUtil/testCodec_TesterManager.h>
#include <nnt/codecUtil/testCodec_UtilOpus.h>
#include <nnt/codecUtil/testCodec_UtilOpusPacketMaker.h>

namespace nnt {
namespace codec {
namespace util {

////////////////////////////////////////////////////////////////////////////////
// Utility functions
////////////////////////////////////////////////////////////////////////////////
std::string GetMountPointHost() NN_NOEXCEPT;
std::string GetMountPointRom() NN_NOEXCEPT;
std::string GetInputDirectoryPath() NN_NOEXCEPT;
std::string GetOutputDirectoryPath() NN_NOEXCEPT;
std::string GetReferenceDirectoryPath() NN_NOEXCEPT;
std::string GetCodecTestBinariesPath() NN_NOEXCEPT;

std::string GetFileExtension(const std::string& path, int dotCount = 1) NN_NOEXCEPT;
////////////////////////////////////////////////////////////////////////////////
// Functions processing parameters in string
////////////////////////////////////////////////////////////////////////////////
std::string GetValueStringLabeledWith(
    const std::string& inputString,
    const std::string& variableName,
    const std::string& startCharactor = "=",
    const std::string& endCharactors = ","
);

std::string GetValueStringLabeledWith(
    const char* inputString,
    const char* variableName,
    const char* startCharactor = "=",
    const char* endCharactors = ","
);

int GetIntegerValueLabeledWith(
    const std::string& inputString,
    const std::string& variableName,
    const std::string& startCharactor = "=",
    const std::string& endCharactors = ","
);

float GetFloatValueLabeledWith(
    const std::string& inputString,
    const std::string& variableName,
    const std::string& startCharactor = "=",
    const std::string& endCharactors = ","
);

// HashValue
bool GetHashValueFromFile(uint8_t hash[], std::size_t hashSize, const std::string& path) NN_NOEXCEPT;
std::string GetHashValueString(const uint8_t hash[], std::size_t hashSize) NN_NOEXCEPT;

// Dump
void Dump(void* buffer, std::size_t size, const std::size_t byteCount = 32, bool isShowAddress = true);

// Math
template <typename T = uint32_t>
inline int Log2(T value) NN_NOEXCEPT
{
    NN_ASSERT_GREATER(value, static_cast<T>(0));
    auto answer = 0;
    for (auto i = 0; 0 != value ; value >>= 1, ++i)
    {
        answer = (value & 1) ? i : 0;
    }
    return answer;
}

}}} // nnt::codec::util
