﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once
#include <nn/atk.h>
#include <nn/mem.h>
#include <nn/nn_Abort.h>
#include <nn/util/util_FormatString.h>

namespace nnt { namespace atk { namespace util {

// クラスとしては 2 つ以上生成できるようになっていますが、
// シングルトンである SoundSystem を AtkCommonSetup 内で設定しているため、
// 一つのテスト項目につき一つのみ Atk セットアップクラスを使うようにしてください。
class AtkCommonSetup
{
public:
    class InitializeParam
    {
    public:
        static const size_t DefaultSoundHeapSize = 4 * 1024 * 1024;

        InitializeParam() NN_NOEXCEPT
        : m_SoundSystemParam()
        , m_SoundHeapSize(DefaultSoundHeapSize)
        , m_SoundArchivePath(nullptr)
        {
        }

        void SetSoundSystemParam(nn::atk::SoundSystem::SoundSystemParam& param) NN_NOEXCEPT;
        const nn::atk::SoundSystem::SoundSystemParam& GetSoundSystemParam() const NN_NOEXCEPT;
        nn::atk::SoundSystem::SoundSystemParam& GetSoundSystemParam() NN_NOEXCEPT;

        void SetSoundHeapSize(size_t size) NN_NOEXCEPT;
        const size_t GetSoundHeapSize() const NN_NOEXCEPT;

        void SetSoundArchivePath(char* path) NN_NOEXCEPT;
        const char* GetSoundArchivePath() const NN_NOEXCEPT;

    private:
        nn::atk::SoundSystem::SoundSystemParam m_SoundSystemParam;
        size_t m_SoundHeapSize;
        char* m_SoundArchivePath;
    };

    AtkCommonSetup();
    ~AtkCommonSetup();

    virtual void Initialize(nn::mem::StandardAllocator& allocator) NN_NOEXCEPT;
    virtual void Initialize(nnt::atk::util::AtkCommonSetup::InitializeParam param, nn::mem::StandardAllocator& allocator) NN_NOEXCEPT;
    virtual void Finalize(nn::mem::StandardAllocator& allocator) NN_NOEXCEPT;
    virtual void LoadData(nn::atk::SoundArchive::ItemId itemId, const char* itemLabel) NN_NOEXCEPT;
    virtual void LoadData(const char* itemLabel) NN_NOEXCEPT;
    void LoadLabelStringData(nn::mem::StandardAllocator& allocator) NN_NOEXCEPT;
    nn::atk::SoundArchive& GetSoundArchive() NN_NOEXCEPT;
    nn::atk::SoundDataManager& GetSoundDataManager() NN_NOEXCEPT;
    nn::atk::SoundArchivePlayer& GetSoundArchivePlayer() NN_NOEXCEPT;
    nn::atk::SoundHeap& GetSoundHeap() NN_NOEXCEPT;

protected:
    virtual void InitializeSoundSystem(nn::mem::StandardAllocator& allocator) NN_NOEXCEPT;
    virtual void InitializeSoundSystem(const nn::atk::SoundSystem::SoundSystemParam param, nn::mem::StandardAllocator& allocator) NN_NOEXCEPT;
    virtual void InitializeSoundArchive(nn::mem::StandardAllocator& allocator) NN_NOEXCEPT;
    virtual void InitializeSoundArchive(const char* soundArchivePath, nn::mem::StandardAllocator& allocator) NN_NOEXCEPT;
    virtual void InitializeFsSoundArchive(const char* soundArchivePath, nn::mem::StandardAllocator& allocator) NN_NOEXCEPT;
    virtual void InitializeSoundDataManager(nn::mem::StandardAllocator& allocator) NN_NOEXCEPT;
    virtual void InitializeSoundArchivePlayer(nn::mem::StandardAllocator& allocator) NN_NOEXCEPT;
    virtual void InitializeSoundHeap(const size_t soundHeapSize, nn::mem::StandardAllocator& allocator) NN_NOEXCEPT;

    virtual void FinalizeSoundSystem(nn::mem::StandardAllocator& allocator) NN_NOEXCEPT;
    virtual void FinalizeSoundArchive(nn::mem::StandardAllocator& allocator) NN_NOEXCEPT;
    virtual void FinalizeFsSoundArchive(nn::mem::StandardAllocator& allocator) NN_NOEXCEPT;
    virtual void FinalizeSoundDataManager(nn::mem::StandardAllocator& allocator) NN_NOEXCEPT;
    virtual void FinalizeSoundArchivePlayer(nn::mem::StandardAllocator& allocator) NN_NOEXCEPT;
    virtual void FinalizeSoundHeap(nn::mem::StandardAllocator& allocator) NN_NOEXCEPT;

    nn::atk::FsSoundArchive     m_FsSoundArchive;
    nn::atk::SoundDataManager   m_SoundDataManager;
    nn::atk::SoundArchivePlayer m_SoundArchivePlayer;
    nn::atk::SoundHeap          m_SoundHeap;

    void* m_pMemoryForSoundSystem;
    void* m_pMemoryForInfoBlock;
    void* m_pMemoryForLabelStringData;
    void* m_pMemoryForSoundDataManager;
    void* m_pMemoryForSoundArchivePlayer;
    void* m_pMemoryForStreamBuffer;
    void* m_pMemoryForSoundHeap;
    bool m_IsInitializedSoundSystem;

    nn::audio::MemoryPoolType m_MemoryPoolForStreamBuffer;
};

}}}
