﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

//---------------------------------------------------------------------------
//  Bq24193 関連パラメータ
//---------------------------------------------------------------------------

#pragma once

#include <nn/nn_Common.h>

#include <nn/i2c/i2c_BusDev.h> // Include development header not in nn/i2c/i2c.h

namespace nnt { namespace i2c { namespace bq24193 {

//---------------------------------------------------------------------------
//  テスト用関数
//---------------------------------------------------------------------------

/**
 * @brief       製品環境相当の I2cDevice 識別子を用いたアクセスができるかをテストします
 *
 * @return      テストが成功したかどうかを返します
 * @retval      true        テストに成功
 * @retval      false       テストに失敗
 * @details     デバイス識別子を使ったアクセスを行います。
 *              デフォルト状態の全レジスタの値を読み出します。
 *              テスト内部で生成したセッションはクローズされ、ライブラリは未初期化状態に戻ります。
 */
bool TEST_I2cDeviceAccess();

}}}  // namespace nnt::i2c::bq24193
