﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstring>
#include <cstdlib>

#include <nn/os.h>
#include <nn/nn_Abort.h>
#include <nn/nn_SdkLog.h>
#include <nn/nn_Common.h>

#include <nnt/nntest.h>

namespace nnt { namespace i2c { namespace util {

const size_t ThreadStackSize = 8192;
typedef void ( *ThreadFunction )( void* arg );

class   ThreadHelper
{
    NN_DISALLOW_COPY(ThreadHelper);
    NN_DISALLOW_MOVE(ThreadHelper);

public:
    ThreadHelper() NN_NOEXCEPT :
        m_ThreadFunction(nullptr)
        {}

    ~ThreadHelper() NN_NOEXCEPT {}

    void CreateThread( int threadId ) NN_NOEXCEPT;
    void StartThread() NN_NOEXCEPT;
    void WaitThread() NN_NOEXCEPT;
    void DestroyThread() NN_NOEXCEPT;
    void SetThreadFunction( ThreadFunction threadFunction ) NN_NOEXCEPT;

private:
    nn::os::ThreadType     m_Thread;
    ThreadFunction         m_ThreadFunction;
    NN_ALIGNAS(4096) char  m_ThreadStack[ ThreadStackSize ];

};

}}}  // namespace nnt::i2c::util
