﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstdlib>
#include <nn/nn_Assert.h>
#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/os.h>
#include <nn/nn_TimeSpan.h>
#include <nn/nn_Log.h>

#include <nn/result/result_HandlingUtility.h>
#include <nn/hidbus/hidbus.h>

#include "RondeUtility.h"

namespace nnt { namespace hidbus {

const int      RondeResultOffset = 0;
const uint8_t  RondeResultSuccess = 0x00;

/////////////////////////////////////////
// 外部非公開関数
/////////////////////////////////////////
nn::Result SendAndReceiveRondeData(uint8_t* cmd, size_t datasize, uint8_t* pOutBuffer, const nn::hidbus::BusHandle& handle) NN_NOEXCEPT
{
    uint8_t* receiveBuffer = new uint8_t[SizeList.Header + datasize];
    size_t  outSize;

    auto result = nn::hidbus::SendAndReceive(&outSize, receiveBuffer, sizeof(receiveBuffer), handle, cmd, sizeof(cmd));
    if (result.IsFailure())
    {
        return result;
    }
    // Ronde からのデータの Result が 0x00 ではない場合は、Timeout 相当
    if (/*outSize != SizeList.Header + datasize ||*/ receiveBuffer[RondeResultOffset] != RondeResultSuccess)
    {
        return nn::hidbus::ResultExternalDeviceTimeout();
    }
    memcpy(pOutBuffer, &receiveBuffer[4], datasize);

    delete[] receiveBuffer;

    return nn::ResultSuccess();
}

nn::Result GetPollingRondeData(nn::hidbus::JoyPollingReceivedData* pOutData, size_t datasize, int count, const nn::hidbus::BusHandle& handle) NN_NOEXCEPT
{
    nn::hidbus::JoyPollingReceivedData* dataSet = new nn::hidbus::JoyPollingReceivedData[count];

    auto result = (count <= 1) ? nn::hidbus::GetJoyPollingReceivedData(dataSet, handle) : nn::hidbus::GetJoyPollingReceivedData(dataSet, count, handle);

    for (int i = 0; i < count; i++)
    {
        memcpy(&pOutData[i].data, dataSet[i].data, 38);
        memcpy(&pOutData[i].samplingNumber, &dataSet[i].samplingNumber, 8);
        pOutData[i].outSize = dataSet[i].outSize;
    }
    delete[] dataSet;
    return result;
}

}}  // nnt::hidbus
