﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "hidfw/gfx.h"
#include "hidfw/hid.h"
#include "hidfw/layout.h"

#include <nn/hid/hid_ControllerSupport.h>
#include <nn/account/account_Api.h>
#include <nn/account/account_ApiForApplications.h>
#include <nn/account/account_Result.h>
#include <nn/account/account_Selector.h>
#include <nn/swkbd/swkbd_Api.h>
#include <nn/err.h>

#include "ApplicationHeap.h"

namespace nnt {

    void MakeAppletButtons(float x, float y);
    void UpdateAppletButtons(void);
    void DrawAppletButtons(void);

    void CallControllerSupportApplet(void* pushButton, void* param);
    void CallAccountSelectApplet(void* pushButton, void* param);
    void CallSwKeyBoardApplet(void* pushButton, void* param);
    void CallErrorViewerApplet(void* pushButton, void* param);
    void CallNullAccess(void * pushButton, void * param);
    void ChangeThredZero(void* pushButton, void* param);
    void ChangeThredOne(void* pushButton, void* param);

    void DoControllerSupportApplet(void* dummy);
    void DoAccountSelectApplet(void* dummy);
    void DoSwKeyBoardApplet(void* dummy);
    void DoErrorViewerApplet(void* dummy);
    void DoNullAccess(void * dummy);

}
