﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Assert.h>
#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Log.h>
#include <nn/hid/hid_SixAxisSensor.h>
#include <nn/util/util_Vector.h>

#include "TrackMotionDetector.h"
#include "SixAxisSensorGestureProcessor.h"

namespace {

} // namespace

TrackMotionDetector::TrackMotionDetector() NN_NOEXCEPT
    : m_RotationAxis(0.f, 0.f, -1.f)
{
    // 何もしない
}

TrackMotionDetector::~TrackMotionDetector() NN_NOEXCEPT
{
    // 何もしない
}

void TrackMotionDetector::Reset() NN_NOEXCEPT
{
    m_Lifo.Clear();
}

void TrackMotionDetector::Update(const SixAxisSensorRawState& rawState) NN_NOEXCEPT
{
    // データ更新
    for (int i = 2; i > 0; i--)
    {
        m_RawStates[i] = m_RawStates[i - 1];
    }
    m_RawStates[0] = rawState;

    // 重力加速度を微分する
    ::nn::util::Vector3f delta0, delta1;
    ::nn::util::VectorSubtract(&delta0, m_RawStates[0].gravity, m_RawStates[1].gravity);
    ::nn::util::VectorSubtract(&delta1, m_RawStates[1].gravity, m_RawStates[2].gravity);
    if (::nn::util::VectorNormalize(&delta0, delta0) != 0 &&
        ::nn::util::VectorNormalize(&delta1, delta1))
    {
        // auto cos = ::nn::util::VectorDot(delta0, delta1);
        // NN_LOG("%f, %f, %f, %f\n"
        //     , cos
        //     , m_RawStates[0].gravity.GetX(), m_RawStates[0].gravity.GetY(), m_RawStates[0].gravity.GetZ());
    }

    ::nn::util::Vector3f workVector;
    if (::nn::util::VectorNormalize(&workVector, rawState.gravity))
    {
        // auto cos = ::nn::util::VectorDot(m_RotationAxis, workVector);
        // NN_LOG("%f, %f, %f, %f\n"
        //     , cos
        //     , workVector.GetX()
        //     , workVector.GetY()
        //     , workVector.GetZ());
    }
}

int TrackMotionDetector::GetMotions(MotionState* pOutStates, int count) NN_NOEXCEPT
{
    return m_Lifo.Read(pOutStates, count);
}
