﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "UniquePadController.h"
#include "IScene.h"
#include "LineChart.h"
#include "PacketChart.h"

class SceneRxPacketHistory final : public IScene
{
    NN_DISALLOW_COPY(SceneRxPacketHistory);
    NN_DISALLOW_MOVE(SceneRxPacketHistory);

private:
    LineChart m_LineChartPlr;
    LineChart m_LineChartReceived;
    UniquePadList* m_pControllers;

    bool m_IsMenuLocked;

public:
    SceneRxPacketHistory() NN_NOEXCEPT;
    virtual ~SceneRxPacketHistory() NN_NOEXCEPT NN_OVERRIDE { /* 何もしない */ };
    virtual void OnSceneFocused() NN_NOEXCEPT NN_OVERRIDE;
    void SetUniquePadList(UniquePadList* pControllers) NN_NOEXCEPT;
    virtual PackedButton Control(const PackedButton& button) NN_NOEXCEPT NN_OVERRIDE;

protected:
    virtual void DrawImpl(RecordablePosition& position) NN_NOEXCEPT NN_OVERRIDE;
    virtual std::string GetGuideString() NN_NOEXCEPT NN_OVERRIDE
    {
        if (m_IsMenuLocked)
        {
            return "\uE0ED/\uE0EE Num of Samples   \uE0EB/\uE0EC Zoom   \uE0E2/\uE0E3 Shift YAxis   \uE0E4/\uE0E5 Reset   \uE0EF/\uE0F0 Unlock";
        }
        return "\uE0EF/\uE0F0 Lock";
    }
    virtual std::string GetSceneName() NN_NOEXCEPT NN_OVERRIDE
    {
        return "PacketHistory";
    }
};
