﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstdlib>
#include <nn/nn_Common.h>
#include <nn/gfx/util/gfx_DebugFontTextWriter.h>

struct DisplayUnit
{
    nn::gfx::util::DebugFontTextWriter* pWriter;
    float x;
    float y;

    void SetCursor()
    {
        pWriter->SetCursor(x, y);
    }
};

// 描画位置の設定
const int DisplayXPosition_Default          = 24;
const int DisplayXOffset_UniquePadId        = DisplayXPosition_Default;
const int DisplayXOffset_ControllerNumber   = DisplayXPosition_Default + 100;
const int DisplayXOffset_InterfaceName      = DisplayXPosition_Default + 200;
const int DisplayXOffset_TypeName           = DisplayXPosition_Default + 360;
const int DisplayXOffset_Reason             = DisplayXPosition_Default + 480;
const int DisplayXOffset_FwVersion          = DisplayXPosition_Default + 640;

const int DisplayXOffset_UpdateStage        = DisplayXPosition_Default + 64;
const int DisplayXOffset_ProgressBar        = DisplayXPosition_Default + 64;
const int DisplayXOffset_UpdateResult       = DisplayXPosition_Default + 64;

const int DisplayXOffset_LocalNetwork       = 800;
const int DisplayXOffset_Help               = 800;

const int DisplayYOffset_Line               = 32;

const int DisplayYOffset_UpdateInfo         = 500;
const int DisplayYOffset_LocalNetwork       = 540;
const int DisplayYOffset_Help               = 680;

// 色
extern const nn::util::Color4u8Type Display_ColorWhite;
extern const nn::util::Color4u8Type Display_ColorGreen;
extern const nn::util::Color4u8Type Display_ColorRed;
extern const nn::util::Color4u8Type Display_ColorGray;
extern const nn::util::Color4u8Type Display_ColorSilver;
extern const nn::util::Color4u8Type Display_ColorOrange;
