﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
    @brief
    アプリのレイアウトを描画します
*/
#include "frm_Layout.h"

const int NXWidth = 1280;
const int NXHeight = 720;

namespace frm{

    /* Singleton パターン */
    Layout& Layout::GetInstance() NN_NOEXCEPT
    {
        static Layout Instance;
        return Instance;
    }

    void Layout::Draw(GraphicsSystem* pGraphicsSystem) NN_NOEXCEPT
    {
        nns::gfx::PrimitiveRenderer::Renderer* pPrimitiveRenderer = &pGraphicsSystem->GetPrimitiveRenderer();

        // 外枠の作成
        pPrimitiveRenderer->SetLineWidth(1.f);
        pPrimitiveRenderer->SetColor(Color::Gray);
        pGraphicsSystem->GetPrimitiveRenderer().Draw2DFrame(&pGraphicsSystem->GetCommandBuffer(), 1, 0, NXWidth - 1, NXHeight - 1);

        // 背景色の作成
        pPrimitiveRenderer->SetColor(ClearColor::Gray);
        pGraphicsSystem->GetPrimitiveRenderer().Draw2DRect(&pGraphicsSystem->GetCommandBuffer(), 0, 0, NXWidth, NXHeight);

        // 右枠の作成
        const int X = 860;
        const int Y = 250;
        pPrimitiveRenderer->SetLineWidth(1.f);
        pPrimitiveRenderer->SetColor(Color::Gray);
        pGraphicsSystem->GetPrimitiveRenderer().Draw2DLine(&pGraphicsSystem->GetCommandBuffer(), X, Y, NXWidth, Y);
        pGraphicsSystem->GetPrimitiveRenderer().Draw2DLine(&pGraphicsSystem->GetCommandBuffer(), X, 0, X, NXHeight);
        // 上部枠の作成
        pGraphicsSystem->GetPrimitiveRenderer().Draw2DLine(&pGraphicsSystem->GetCommandBuffer(), 0, 30, X, 30);

    }
}
// [EOF]

