﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/hid/hid_NpadCommonTypes.h>
#include <nn/hid/hid_NpadJoyDual.h>

#include "ConsoleSixAxisSensorSampler.h"
#include "SixAxisSensorLogger.h"

const int TestIdCountMax = 10; //!< テストの最大数

struct TestId
{
    int id;

    TestId()
        : id(0)
    {
        // 何もしない
    }

    void Next()
    {
        id = (id + 1) % TestIdCountMax;
    }

    void Prev()
    {
        if (id == 0)
        {
            id = TestIdCountMax - 1;
        }
        else
        {
            id--;
        }
    }
};

class CommandHandler
{
    NN_DISALLOW_COPY(CommandHandler);
    NN_DISALLOW_MOVE(CommandHandler);

private:
    TestId m_TestId;

    ConsoleSixAxisSensorSampler* m_pSampler;
    SixAxisSensorLogger* m_pLogger;

public:
    CommandHandler() NN_NOEXCEPT;

    void SetConsoleSixAxisSensorSampler(ConsoleSixAxisSensorSampler* pSampler) NN_NOEXCEPT;

    void SetSixAxisSensorLogger(SixAxisSensorLogger* pLogger) NN_NOEXCEPT;

    void Update(const nn::hid::NpadButtonSet& buttons) NN_NOEXCEPT;

    int GetTestId() const NN_NOEXCEPT;
};

