﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_TimeSpan.h>
#include <nn/hid.h>
#include <nn/hid/debug/hid_TouchScreen.h>
#include <nn/os.h>
#include <nnt/nntest.h>

#include "../Common/testHid_TouchScreen.h"

//!< 入力状態は 4 ms 以上の間隔を開けて追加されるか
TEST(TouchScreenPerformanceSuite, StateReadingTest1)
{
    ::nn::hid::InitializeTouchScreen();

    ::nn::hid::TouchScreenState<1> state1 = {};

    ::nn::hid::GetTouchScreenState(&state1);

    int64_t expectedCount = ::nn::hid::TouchScreenStateCountMax / 2;

    ::nn::os::SleepThread(
        ::nn::TimeSpan::FromMilliSeconds(
            expectedCount *
            ::nnt::hid::GetTouchScreenSamplingInterval().GetMilliSeconds()));

    ::nn::hid::TouchScreenState<1> state2 = {};

    ::nn::hid::GetTouchScreenState(&state2);

    int64_t observedCount = state2.samplingNumber - state1.samplingNumber + 1;

    EXPECT_LE(expectedCount - 2, observedCount);
    EXPECT_GE(expectedCount + 2, observedCount);

    ::nn::hid::debug::FinalizeTouchScreen();
}
