﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_Log.h>

#include <nn/hid/hid_SixAxisSensor.h>

#include <nnt/nntest.h>

#include "Resources/AttachmentDetector/testHid_AttachedBasic.h"
#include "../../../Programs/Iris/Sources/Libraries/hid/detail/hid_AttachmentDetector.h"

namespace {

const int DataCountPerSample = 12;
const int SampleCountMax = sizeof(nnt::hid::TestData) / sizeof(nnt::hid::TestData[0]) / DataCountPerSample;

void GetSample(nn::hid::SixAxisSensorState* pOutLeftState,
               nn::hid::SixAxisSensorState* pOutRightState,
               int sample) NN_NOEXCEPT
{
    NN_ABORT_UNLESS(sample < SampleCountMax);

    int index = DataCountPerSample * sample;

    pOutLeftState->acceleration.x = nnt::hid::TestData[index++];
    pOutLeftState->acceleration.y = nnt::hid::TestData[index++];
    pOutLeftState->acceleration.z = nnt::hid::TestData[index++];
    pOutLeftState->angularVelocity.x = nnt::hid::TestData[index++];
    pOutLeftState->angularVelocity.y = nnt::hid::TestData[index++];
    pOutLeftState->angularVelocity.z = nnt::hid::TestData[index++];

    pOutRightState->acceleration.x = nnt::hid::TestData[index++];
    pOutRightState->acceleration.y = nnt::hid::TestData[index++];
    pOutRightState->acceleration.z = nnt::hid::TestData[index++];
    pOutRightState->angularVelocity.x = nnt::hid::TestData[index++];
    pOutRightState->angularVelocity.y = nnt::hid::TestData[index++];
    pOutRightState->angularVelocity.z = nnt::hid::TestData[index++];
}

} // namespace

//!< AttachmentDetector がアタッチ状態の6軸センサー入力系列で検出に成功するか
TEST(SixAxisSensorCalculation, AttachmentDetectorTest1)
{
    nn::hid::detail::AttachmentDetector detector;
    nn::hid::SixAxisSensorState leftState;
    nn::hid::SixAxisSensorState rightState;

    int detectedSampleCount = 272; // 現在のアルゴリズムで検出までにかかるサンプル数
    for(int i = 0; i < SampleCountMax; i++)
    {
        // データ取得
        GetSample(&leftState, &rightState, i);

        // 確率の更新
        detector.UpdateProbability(leftState, rightState);
        if(detector.IsAttached())
        {
            detectedSampleCount = i;
            NN_LOG("Attachment is detected at %d th sample\n", detectedSampleCount);
            break;
        }
    }

    // 検出速度が遅くなっていないか
    EXPECT_LE(detectedSampleCount, SampleCountMax);
}
