﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>
#include <nn/hid.h>
#include <nn/hid/hid_Npad.h>
#include <nn/hid/system/hid_Npad.h>
#include <nn/hid/hid_Result.h>
#include <nnt/nntest.h>

#include "testHid_NpadCommon.h"
#include "../Common/testHid_Npad.h"

//!< NpadId 未初期化時に失敗する
TEST(NpadJoyHoldType, DefaultHoldType)
{
    // デフォルトは縦持ち
    EXPECT_DEATH_IF_SUPPORTED(nn::hid::GetNpadJoyHoldType(), "");

    ::testhid::EnableIdAll();

    // NpadId を有効にしても影響はない
    auto holdType = nn::hid::GetNpadJoyHoldType();
    EXPECT_EQ(nn::hid::NpadJoyHoldType_Vertical, holdType);

    ::testhid::DisableIdAll();
}

//!< 有効な　Id がある場合に持ち方の変更は可能
TEST(NpadJoyHoldType, ChangeHoldTypeWithNpadSupported)
{
    ::testhid::EnableIdAll();

    // 横持ちに変更
    nn::hid::SetNpadJoyHoldType(nn::hid::NpadJoyHoldType_Horizontal);

    auto holdType = nn::hid::GetNpadJoyHoldType();
    EXPECT_EQ(nn::hid::NpadJoyHoldType_Horizontal, holdType);

    // 上書き
    nn::hid::SetNpadJoyHoldType(nn::hid::NpadJoyHoldType_Horizontal);

    // 縦持ちに戻す
    nn::hid::SetNpadJoyHoldType(nn::hid::NpadJoyHoldType_Vertical);

    holdType = nn::hid::GetNpadJoyHoldType();
    EXPECT_EQ(nn::hid::NpadJoyHoldType_Vertical, holdType);

    ::testhid::DisableIdAll();
}
