﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/hid/hid_Npad.h>
#include <nn/hid/hid_NpadJoy.h>
#include <nn/hid/hid_NpadGc.h>
#include <nn/hid/hid_NpadPalma.h>
#include <nn/hid/debug/hid_Npad.h>
#include <nn/hid/system/hid_Npad.h>
#include <nn/util/util_BitPack.h>
#include <nnt/nntest.h>


namespace testhid {
    // Nx でサポートされているすべての NpadId
    const nn::hid::NpadIdType NpadIds[] = {
                                       nn::hid::NpadId::No1,
                                       nn::hid::NpadId::No2,
                                       nn::hid::NpadId::No3,
                                       nn::hid::NpadId::No4,
                                       nn::hid::NpadId::No5,
                                       nn::hid::NpadId::No6,
                                       nn::hid::NpadId::No7,
                                       nn::hid::NpadId::No8,
                                       nn::hid::NpadId::Handheld,
                                       nn::hid::system::NpadSystemId::Other,
                                      };
    const int NpadIdCountMax = sizeof(NpadIds) / sizeof(NpadIds[0]);

    // 最小限のテストを行う場合に使用する NpadId
    const nn::hid::NpadIdType NpadIdsMinimalSet[] = {
                                       nn::hid::NpadId::No1,
                                       nn::hid::NpadId::Handheld,
                                       nn::hid::system::NpadSystemId::Other,
                                      };
    const int NpadIdMinimalSetCountMax = sizeof(NpadIdsMinimalSet) / sizeof(NpadIdsMinimalSet[0]);

    // Nx でサポートされているすべてのスタイル
    const nn::hid::NpadStyleSet NpadStyles[] = {
                                       nn::hid::NpadStyleFullKey::Mask,
                                       nn::hid::NpadStyleHandheld::Mask,
                                       nn::hid::NpadStyleJoyDual::Mask,
                                       nn::hid::NpadStyleJoyLeft::Mask,
                                       nn::hid::NpadStyleJoyRight::Mask,
                                       nn::hid::NpadStyleGc::Mask,
                                       nn::hid::NpadStylePalma::Mask,
                                       nn::hid::system::NpadStyleSystem::Mask,
                                       nn::hid::system::NpadStyleSystemExt::Mask,
                                      };

    const int NpadStyleCountMax = sizeof(NpadStyles) / sizeof(NpadStyles[0]);

    //!< サポートされているすべての NpadStyle を有効にする
    void EnableStyleAll() NN_NOEXCEPT;

    //!< サポートされているすべての NpadStyle を無効にする
    void DisableStyleAll() NN_NOEXCEPT;

    //!< サポートされているすべての NpadStyle のマスクを取得する
    nn::hid::NpadStyleSet GetSupportedNpadStyleMask() NN_NOEXCEPT;

    //!< サポートされている全ての NpadIdType を有効にする
    void EnableIdAll() NN_NOEXCEPT;

    //!< サポートされているすべての NpadIdType を無効にする
    void DisableIdAll() NN_NOEXCEPT;

    //!< 指定した NpadId と NpadStyleSet に対して、GetNpadState() の DEATH テストを実施する
    void ExpectDeathGetNpadState(nn::hid::NpadIdType id, nn::hid::NpadStyleSet style) NN_NOEXCEPT;

    //!< 指定した NpadId と NpadStyleSet に対して、GetNpadStates() の DEATH テストを実施する
    void ExpectDeathGetNpadStates(nn::hid::NpadIdType id, nn::hid::NpadStyleSet style) NN_NOEXCEPT;

    //!< 指定した Id と Style に対して GetNpadState() が無入力となることを評価する
    void ExpectNoInputGetNpadState(nn::hid::NpadIdType id, nn::hid::NpadStyleSet style) NN_NOEXCEPT;

    //!< 指定した Id と Style に対して GetNpadStates() が無入力となることを評価する
    void ExpectNoInputGetNpadStates(nn::hid::NpadIdType id, nn::hid::NpadStyleSet style) NN_NOEXCEPT;

    //!< 指定した Id に対して GetNpadState() の結果を評価する
    void TestGetNpadState(nn::hid::NpadIdType id, bool expectDeath) NN_NOEXCEPT;

    //!< 全ての Id に対して GetNpadState() の結果を評価する
    void TestGetNpadState(bool expectDeath) NN_NOEXCEPT;

    //!< 指定した Id に対して GetNpadStates() の結果を評価する
    void TestGetNpadStates(nn::hid::NpadIdType id, bool expectDeath) NN_NOEXCEPT;

    //!< 全ての Id に対して GetNpadStates() の結果を評価する
    void TestGetNpadStates(bool expectDeath) NN_NOEXCEPT;
} // namespace testhid
