﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/nn_TimeSpan.h>
#include <nn/hid.h>
#include <nn/hid/debug/hid_TouchScreen.h>
#include <nn/result/result_HandlingUtility.h>

#include "..\..\..\..\..\Programs\Iris\Sources\Libraries\hid\detail\hid_Rectangle.h"

namespace nnt { namespace hid {

//!< TouchScreen の自動操作状態（自動テスト用）を表す型です。
typedef ::nn::hid::debug::TouchScreenAutoPilotState<
    ::nn::hid::TouchScreenStateCountMax> TouchScreenAutoPilotState;

//!< タッチ数を表す構造体です。
template<int N>
class TouchStateCountType
{
public:
    static const int Value = N; //!< タッチ数
};

//!< TouchScreen のサンプリング間隔を返します。
inline ::nn::TimeSpanType GetTouchScreenSamplingInterval() NN_NOEXCEPT
{
    return ::nn::TimeSpanType::FromMilliSeconds(4);
}

//!< TouchScreen を終了します。（自動操作に関する自動テスト用）
inline void FinalizeTouchScreenForAutoPilot() NN_NOEXCEPT
{
#if !defined(NN_BUILD_CONFIG_OS_WIN)
    ::nn::hid::debug::UnsetTouchScreenAutoPilotState();
    ::nn::os::SleepThread(
        ::nn::TimeSpan::FromMilliSeconds(
            ::nn::hid::TouchScreenStateCountMax *
            GetTouchScreenSamplingInterval().GetMilliSeconds()));
#endif
    ::nn::hid::debug::FinalizeTouchScreen();
}

}} // namespace nnt::hid
