﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_TimeSpan.h>
#include <nn/hid/debug/hid_SleepButton.h>
#include <nn/hid/system/hid_SleepButton.h>
#include <nn/os.h>
#include <nn/TargetConfigs/build_Base.h>

namespace nnt { namespace hid {

//!< スリープボタンのサンプリング間隔を返します。
inline ::nn::TimeSpanType GetSleepButtonSamplingInterval() NN_NOEXCEPT
{
    return ::nn::TimeSpanType::FromMilliSeconds(15);
}

//!< スリープボタンを終了します。（自動操作に関する自動テスト用）
inline void FinalizeSleepButtonForAutoPilot() NN_NOEXCEPT
{
#if !defined(NN_BUILD_CONFIG_OS_WIN)
    ::nn::hid::debug::UnsetSleepButtonAutoPilotState();
    ::nn::os::SleepThread(
        ::nn::TimeSpan::FromMilliSeconds(
            ::nn::hid::system::SleepButtonStateCountMax *
            GetSleepButtonSamplingInterval().GetMilliSeconds()));
#endif
    ::nn::hid::debug::FinalizeSleepButton();
}

}} // namaspace nnt::hid
