﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Log.h>
#include <nn/nn_Assert.h>
#include <nn/os.h>
#include <nn/pl/pl_BridgeApi.h>
#include <nn/cec/cec_Api.h>
#include <nnt/nntest.h>
#include <algorithm>

#include "testHdcp_Util-hardware.nx.h"
#include "testHdcp_Config.h"

namespace nnt { namespace hdcp {

bool TriggerPseudoDockOut(int64_t waitingMSec) NN_NOEXCEPT
{
    auto result = nn::pl::SetUsbDetachedForDebug(true);
    if (result.IsSuccess())
    {
        if (0LL < waitingMSec)
        {
            nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(waitingMSec));
        }
        return true;
    }
    NN_ASSERT(0);
    return false;
}

bool TriggerPseudoDockIn(int64_t waitingMSec) NN_NOEXCEPT
{
    auto result = nn::pl::SetUsbDetachedForDebug(false);
    if (result.IsSuccess())
    {
        if (0LL < waitingMSec)
        {
            nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(waitingMSec));
        }
        return true;
    }
    NN_ASSERT(0);
    return false;
}

int64_t GetCurrentMilliSeconds()
{
    return nn::os::GetSystemTick().ToTimeSpan().GetMilliSeconds();
}

}}  // namespace nnt::hdcp
