﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Log.h>
#include <nn/nn_Assert.h>
#include <nn/cec/cec_Api.h>
#include <nnt/nntest.h>
#include <algorithm>

#include "HdcpTestInitializer.h"
#include "testHdcp_Config.h"

namespace nnt { namespace hdcp {

namespace {

}

NN_IMPLICIT HdcpTestInitializer::HdcpTestInitializer() NN_NOEXCEPT
{
    nn::cec::Initialize(&m_CecEventType);
    nn::cec::GetHdcpServiceObject(&m_HdcpService);
    hdcpc::Initialize(m_HdcpService);
}

HdcpTestInitializer::~HdcpTestInitializer() NN_NOEXCEPT
{
    hdcpc::Finalize();
    nn::cec::Finalize(&m_CecEventType);
}

HdcpService HdcpTestInitializer::GetHdcpServiceObject() NN_NOEXCEPT
{
    return m_HdcpService;
}

}}  // namespace nnt::hdcp
