﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "testUi2d_SimpleAllocator.h"

void* SimpleAllocator::AllocateMemory(size_t size, size_t alignment)
{
    m_OccupiedSize += size;
    if (m_MaxSize < m_OccupiedSize)
    {
        m_MaxSize = m_OccupiedSize;
    }

    void* pBuffer = m_ApplicationHeapHandle.Allocate(size, static_cast<int>(alignment));

    // メモリリストに追加
    MemoryList* pItem = static_cast<MemoryList*>(m_ApplicationHeapHandle.Allocate(sizeof(MemoryList)));
    pItem->pNext = NULL;
    pItem->pAddress = pBuffer;
    pItem->size = size;
    if (m_pTop == NULL)
    {
        m_pTop = pItem;
        m_pBottom = pItem;
    }
    else
    {
        m_pBottom->pNext = pItem;
        m_pBottom = pItem;
    }

    return pBuffer;
}

void SimpleAllocator::FreeMemory(void* pointer)
{
    if (pointer == NULL)
    {
        return;
    }

    // メモリリストから削除
    MemoryList* pPrev = NULL;
    MemoryList* pItem = m_pTop;
    while (pItem != NULL)
    {
        if (pItem->pAddress == pointer)
        {
            break;
        }
        pPrev = pItem;
        pItem = pItem->pNext;
    }
    NN_ASSERT(pItem != NULL, "Memory item was not found.");
    m_OccupiedSize -= pItem->size;
    if (pPrev == NULL)
    {
        m_pTop = pItem->pNext;
    }
    else
    {
        pPrev->pNext = pItem->pNext;
    }
    if (pItem->pNext == NULL)
    {
        m_pBottom = pPrev;
    }
    m_ApplicationHeapHandle.Free(pItem);
    m_ApplicationHeapHandle.Free(pointer);
}

int64_t SimpleAllocator::GetOccupiedSize() const
{
    return m_OccupiedSize;
}

int64_t SimpleAllocator::GetMaxSize() const
{
    return m_MaxSize;
}

void SimpleAllocator::ResetMaxSize()
{
    m_MaxSize = 0;
}

void SimpleAllocator::PrintOccupiedMemory() const
{
    NN_LOG("Occupied memory: current = %lld, max = %lld\n", GetOccupiedSize(), GetMaxSize());

    MemoryList* pItem = m_pTop;
    while (pItem != NULL)
    {
        NN_LOG("Occupied memory: %d byte (0x%p)\n", pItem->size, pItem->pAddress);
        pItem = pItem->pNext;
    }
}
