﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @examplesource{TextureData.h,PageSampleNvnTutorial02}
 *
 * @brief
 *  This file defines data structures used to hold information
 *  about the texture data during the conversion process.
 */

#pragma once

#include <vector>

namespace nvnTool { namespace texpkg {

class RawImage;

}}

struct MipMapData
{
    std::string m_FileName;
    int m_Level;
};

struct TextureData
{
    std::string m_FileName;
    nvnTool::texpkg::RawImage* m_pRawImage;
    std::vector<MipMapData> m_MipMaps;
};

struct CubeMapData
{
    std::string m_Name;
    nvnTool::texpkg::RawImage* m_pRawImage;
    std::vector<std::string> m_Faces;
};
