﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/util/util_Vector.h>
#include <vector>
#include <map>

namespace Icosphere
{
    struct Triangle
    {
        int vertex[3];
    };

    typedef std::vector<nn::util::Vector3fType> VertexList;
    typedef std::vector<Triangle> TriangleList;
    typedef std::map<std::pair<int, int>, int> Lookup;
    typedef std::pair<VertexList, TriangleList> IndexedMesh;

    const float X = .525731112119133606f;
    const float Z = .850650808352039932f;
    const float N = 0.f;

    static const VertexList initialVertexList =
    {
        { -X,N,Z },{ X,N,Z },{ -X,N,-Z },{ X,N,-Z },
        { N,Z,X },{ N,Z,-X },{ N,-Z,X },{ N,-Z,-X },
        { Z,X,N },{ -Z,X, N },{ Z,-X,N },{ -Z,-X, N }
    };

    static const TriangleList initialTriangleList =
    {
        {{ 0,4,1 }}, {{ 0,9,4 }}, {{ 9,5,4 }}, {{ 4,5,8 }}, {{ 4,8,1 }},
        {{ 8,10,1 }},{{ 8,3,10 }},{{ 5,3,8 }}, {{ 5,2,3 }}, {{ 2,7,3 }},
        {{ 7,10,3 }},{{ 7,6,10 }},{{ 7,11,6 }},{{ 11,0,6 }},{{ 0,1,6 }},
        {{ 6,1,10 }},{{ 9,0,11 }},{{ 9,11,2 }},{{ 9,2,5 }}, {{ 7,2,11 }}
    };

    int vertexForEdge(Lookup& lookup, VertexList& vertices, int first, int second);

    void makeIcosphere(int subdivisions, IndexedMesh* mesh);
}
