@echo off

For %%G in ("%~dp0..\..\..\..\..\..\..") do set SIGLO_ROOT=%%~fG

set RUN_ON_TARGET=%SIGLO_ROOT%\Tools\CommandLineTools\RunOnTarget.exe
set DEV_MENU_COMMAND_NSP=%SIGLO_ROOT%\Programs\Eris\Outputs\NX-NXFP2-a64\TargetTools\DevMenuCommand\Release\DevMenuCommand.nsp
set LOG_FILE=log.txt

echo RUN_PARAMETERS %RUN_PARAMETERS%


nact.exe -m specs=NX platforms=NXFP2-a64 BUILD=full -F testGfxUtil_GpuBenchmark -F testGfxUtil_AgingTest -F DevMenuCommand
if ERRORLEVEL 1 goto error

nact.exe -m specs=Generic BUILD=full -F RunOnTarget
if ERRORLEVEL 1 goto error

echo. > %LOG_FILE%

for %%P in (console, handheld) do (

    %RUN_ON_TARGET% %DEV_MENU_COMMAND_NSP% debug set-operation-mode-policy %%P
    if ERRORLEVEL 1 goto error

    for %%B in (Debug, Develop, Release) do (
        echo Running %%P %%B
        %RUN_ON_TARGET% %SIGLO_ROOT%\Tests\Outputs\NX-NXFP2-a64\Tests\testGfxUtil_GpuBenchmark\%%B\testGfxUtil_GpuBenchmark.nsp -- %RUN_PARAMETERS% >> %LOG_FILE%
        if ERRORLEVEL 1 goto error
    )
)

echo Successfully finished

goto end

:error
echo An error occured
exit /b 1

:end
exit /b 0



