﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

INOUT Varying
{
    vec4 color;
} InOut;

layout(std140, binding = 0) uniform ConstantBuffer
{
    int gridSize;
};

#if VERTEX_SHADER

#if ATTRIBUTE_COUNT > 0
layout(location = 0) in vec4 i_Input0;
#endif

#if ATTRIBUTE_COUNT > 1
layout(location = 1) in vec4 i_Input1;
#endif

#if ATTRIBUTE_COUNT > 2
layout(location = 2) in vec4 i_Input2;
#endif

#if ATTRIBUTE_COUNT > 3
layout(location = 3) in vec4 i_Input3;
#endif

#if ATTRIBUTE_COUNT > 4
layout(location = 4) in vec4 i_Input4;
#endif

#if ATTRIBUTE_COUNT > 5
layout(location = 5) in vec4 i_Input5;
#endif

in int gl_VertexID;

void main()
{
    int gridIndex   = gl_VertexID / 6;
    int vertexIndex = gl_VertexID % 6;

    int gridX       = gridIndex % (gridSize + 1);
    int gridY       = gridIndex / (gridSize + 1);

    float x         = float(gridX);
    float y         = float(gridY);
    float offsetX   = 0.0;
    float offsetY   = 0.0;

    if ((vertexIndex == 1) || (vertexIndex == 3) || (vertexIndex == 5))
        offsetX = 1.0;

    if ((vertexIndex == 2) || (vertexIndex == 4) || (vertexIndex == 5))
        offsetY = 1.0;

    float scale     = 1.0f / float(gridSize);
    float posX      = (x + offsetX) * scale;
    float posY      = (y + offsetY) * scale;

    float clipSpaceX = (posX * 2.0) - 1.0;
    float clipSpaceY = (posY * 2.0) - 1.0;

    gl_Position = vec4(clipSpaceX, clipSpaceY, 0.5, 1.0);

    vec4 color = vec4(x * scale, y * scale, 0, 0);

    vec4 outputAcc = vec4(0, 0, 0, 0);

#if ATTRIBUTE_COUNT > 0
    outputAcc += i_Input0;
#endif

#if ATTRIBUTE_COUNT > 1
    outputAcc += i_Input1;
#endif

#if ATTRIBUTE_COUNT > 2
    outputAcc += i_Input2;
#endif

#if ATTRIBUTE_COUNT > 3
    outputAcc += i_Input3;
#endif

#if ATTRIBUTE_COUNT > 4
    outputAcc += i_Input4;
#endif

#if ATTRIBUTE_COUNT > 5
    outputAcc += i_Input5;
#endif

    InOut.color = color + outputAcc;
}

#endif

#if PIXEL_SHADER

layout(location = 0) out vec4 o_Color;

void main()
{
    o_Color = InOut.color;
}

#endif
