﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

 #pragma unroll all

INOUT Varying
{
    vec4 interp0;
} InOut;

layout(std140, binding = 0) uniform ConstantBuffer
{
    vec4 transformMatrix[64][4];
};

#if VERTEX_SHADER

in int gl_VertexID;
in int gl_InstanceID;

void main()
{
    int instanceIndex       = gl_InstanceID;
    int instanceGridSize    = (gl_VertexID >> 2) & 0xFFFF;
    int instanceX           = instanceIndex % instanceGridSize;
    int instanceY           = instanceIndex / instanceGridSize;


    float x         = float(gl_VertexID & 0x01);
    float y         = float((gl_VertexID & 0x02) >> 1);
    float offsetX   = float(instanceX);
    float offsetY   = float(instanceY);
    float scale     = 1.0f / float(instanceGridSize);
    float posX      = (x + offsetX) * scale;
    float posY      = (y + offsetY) * scale;

    float clipSpaceX = (posX * 2.0) - 1.0;
    float clipSpaceY = (posY * 2.0) - 1.0;

    vec4 result = vec4(clipSpaceX, clipSpaceY, 0.5, 1.0);

    const int transformCount = VERTEX_TRANSFORM_COUNT;
    for (int i = 0; i < transformCount; ++i)
    {
        vec4 tmp = result;
        result.x = dot(transformMatrix[i % 64][0], tmp);
        result.y = dot(transformMatrix[i % 64][1], tmp);
        result.z = dot(transformMatrix[i % 64][2], tmp);
        result.w = dot(transformMatrix[i % 64][3], tmp);
    }

    gl_Position = result;
    InOut.interp0 = vec4(float(instanceX), float(instanceY), float(instanceGridSize), 1.0);
}

#endif

#if PIXEL_SHADER

layout(location = 0) out vec4 o_Color;

void main()
{
    vec4 result = InOut.interp0;
    const int transformCount = PIXEL_TRANSFORM_COUNT;
    for (int i = 0; i < transformCount; ++i)
    {
        vec4 tmp = result;
        result.x = dot(transformMatrix[i % 64][0], tmp);
        result.y = dot(transformMatrix[i % 64][1], tmp);
        result.z = dot(transformMatrix[i % 64][2], tmp);
        result.w = dot(transformMatrix[i % 64][3], tmp);
    }

    o_Color = vec4(result.x / result.z, result.y / result.z, 1.0, result.w);
}

#endif
