﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once


#include <nn/nn_Abort.h>
#include <nn/nn_Assert.h>
#include <nn/nn_Log.h>



#include "gfxUtilGpuBenchmark_GpuBenchmark.h"

namespace nnt { namespace gfx { namespace util { namespace agingtest {

class ValidationResultData
{
private:
    int runCount;
    int totalMiss;
    int missOver;
    int missBelow;
    bool hasFailed;

public:
                    ValidationResultData();
                    ~ValidationResultData();

    void            Clear();
    void            Update(ValidationResult result);

    double          ComputeFailureRate() const;
    double          ComputeFailureRateOver() const;
    double          ComputeFailureRateBelow() const;

    bool            GetIsFailed() const;
    bool            UpdateIsFailed(double failureThresold);
};

inline double ValidationResultData::ComputeFailureRate() const
{
    if (runCount == 0)
        return 0.0;

    return static_cast<double>(totalMiss) / static_cast<double>(runCount);
}

inline double ValidationResultData::ComputeFailureRateOver() const
{
    if (runCount == 0)
        return 0.0;

    return static_cast<double>(missOver) / static_cast<double>(runCount);
}

inline double ValidationResultData::ComputeFailureRateBelow() const
{
    if (runCount == 0)
        return 0.0;

    return static_cast<double>(missBelow) / static_cast<double>(runCount);
}

inline bool ValidationResultData::GetIsFailed() const
{
    return hasFailed;
}


} } } } // namespace nnt { namespace gfx { namespace util { namespace agingtest {
