﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#ifdef __cplusplus
extern "C" {
#endif

#define SCREEN_WIDTH  (DEMOColorBuffer.surface.width)
#define SCREEN_HEIGHT (DEMOColorBuffer.surface.height)

extern u32 RENDERWidth;
extern u32 RENDERHeight;

// Render Target for Scene Draw
extern nn::gfx::DepthStencilView g_R2TDepthBuffer;

extern nn::gfx::ColorTargetView  g_R2TColorBuffer;
extern nn::gfx::Texture          g_R2TTexture;
extern nn::gfx::TextureView      g_R2TTextureView;
extern nn::gfx::DescriptorSlot   g_R2TTextureSlot;
extern DEMOGfxMemPool* g_pR2TTexturePool;

extern nn::gfx::Sampler g_R2TSampler;
extern nn::gfx::DescriptorSlot g_R2TSamplerSlot;

extern u8 RENDERScene;

void SceneInit();
void SceneDraw();
void SceneShutdown();

void InitBC1Shader();
void CompressBC1Runtime();

#ifdef __cplusplus
}
#endif


