#
# Arg0: NintendoSDK root path
# Arg1: test name e.g. testGfx_BaseInstance
# Arg2: destination root path
# Arg3: specify build or clean
#

#$sdkRootPath=$args[0]
$scriptPath          = $MyInvocation.MyCommand.Path
$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($scriptPath)
$sdkRootPath = $scriptDirectoryPath + "\..\..\..\..\..\.."
$testName = $args[1]
$destRootPath = [System.IO.Path]::GetFullPath($args[2])
$buildOption = $args[3]


# Shader source path.
$svnTestSourcePath = $sdkRootPath + "\Externals\TestBinaries\Gfx\Sources\$testName"
# Prebuild path
$svnTestPrebuiltPath = $sdkRootPath + "\Externals\TestBinaries\Gfx\Prebuilt\$testName"

$grsfPath = $destRootPath + "\shaders"
$capturePath = $destRootPath + "\capture"
$svnGeometries = $svnTestPrebuiltPath + "\Generic\geometries"
$svnTextures = $svnTestPrebuiltPath + "\Generic\textures"
$svnShaders = $svnTestPrebuiltPath + "\Generic\shaders"


# Build function
function Build
{
	# Creating directories
	if( -not ( test-path $grsfPath ) )
	{
		New-Item $grsfPath -type directory 
	}

	# capture
	if( -not ( test-path $capturePath ) )
	{
		New-Item $capturePath -type directory
	}

	# Copy geometry and textures.
	# This is because we'd like to use newly converted grsf rather than prebuilt one and directory structure consistency with svn is required.
	Try
	{
		# if exists geometries
		if( test-path $svnGeometries )
		{
	        copy-item $svnGeometries -destination $destRootPath -recurse
		}

		# if exists textures
		if( test-path $svnTextures )
		{
	        copy-item $svnTextures -destination $destRootPath -recurse
		}

		# copy demoFont.grsf
		# NOTE: Other grsf are created by this script.
		if( test-path $svnShaders )
		{
	        copy-item $svnShaders\demoFont.grsf $grsfPath\demoFont.grsf
		}
	}
	Catch
	{
	    echo "ERROR: Copy failed."
	    exit 1
	}

	# Create grsf
	Try
	{
		# Invoke batch
		$postBuildBat = $svnTestSourcePath + "\postbuild.bat"
		& $postBuildBat "Win64" "Develop" $sdkRootPath $svnTestSourcePath $destRootPath ".glsl" $destRootPath
	}
	Catch
	{
	    echo "ERROR: Create grsf failed."
	    exit 1
	}
}

# Clean function
function Clean
{
	Remove-Item $grsfPath -Recurse
	Remove-Item $capturePath -Recurse
	Remove-Item $destRootPath\geometries -Recurse
	Remove-Item $destRootPath\textures -Recurse
	Remove-Item $destRootPath\shaders -Recurse
	Remove-Item $destRootPath\*.glsl
}

switch -r ( $buildOption )
{
  "build" { Build }
  "clean" { Clean }
  default { Build }
}
