﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "testG3d_ViewerTestAllocator.h"
#include "testG3d_ViewerTestUtility.h"
#include <nnt/base/testBase_Exit.h>
#include <nnt/g3d/testG3d_TestUtility.h>
#include <nnt/nntest.h>
#include <nnt/nnt_Argument.h>
#include <nn/htcs.h>
#include <nn/nn_Log.h>

using namespace G3dTest;

extern "C" void nnMain()
{
    int     argc = nnt::GetHostArgc();
    char**  argv = nnt::GetHostArgv();

    ::testing::InitGoogleTest(&argc, argv);

    nnt::g3d::InitializeG3dTest(*GetDevice());

    // htcs は内部で呼んでいる tma が非同期的に裏で new をするため、
    // 環境やタイミングによってはメモリリーク検出テストが失敗してしまう可能性があるので
    // CIでもし問題になれば、メモリリーク検出テストは SIGLO-16001 の対応が行われるまで無効にする
    NN_LOG("nn::htcs::Initialize\n");
    nn::htcs::Initialize(
        ViewerTestAllocator::Allocate,
        ViewerTestAllocator::Deallocate);
    NN_LOG("nn::htcs::Initialize Completed\n");


    int result = RUN_ALL_TESTS();


    NN_LOG("nn::htcs::Finalize\n");
    nn::htcs::Finalize();
    EXPECT_FALSE(nn::htcs::IsInitialized());
    NN_LOG("nn::htcs::Finalize Completed\n");

    nnt::g3d::FinalizeG3dTest(*GetDevice());

    nnt::Exit(result);
}
