﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstdlib>
#include <nnt/base/testBase_Exit.h>
#include <nnt/g3d/testG3d_TestUtility.h>
#include <nnt/nntest.h>
#include <nnt/nnt_Argument.h>
#include <nn/nn_Log.h>
#include <nn/fs/fs_Mount.h>
#include <nn/fs/fs_Rom.h>
#include <nn/fs/fs_MemoryManagement.h>
#include <nv/nv_MemoryManagement.h>
#include "testG3d_MiiConvertTest.h"


#if defined( NN_BUILD_CONFIG_OS_SUPPORTS_HORIZON )
void* NvAllocate(size_t size, size_t alignment, void* userPtr) NN_NOEXCEPT
{
    NN_UNUSED(userPtr);
    return aligned_alloc(alignment, size);
}

void NvFree(void* addr, void* userPtr) NN_NOEXCEPT
{
    NN_UNUSED(userPtr);
    free(addr);
}

void* NvReallocate(void* addr, size_t newSize, void* userPtr) NN_NOEXCEPT
{
    NN_UNUSED(userPtr);
    return realloc(addr, newSize);
}
#endif

extern "C" void nnMain()
{
    int     argc = nnt::GetHostArgc();
    char**  argv = nnt::GetHostArgv();

    ::testing::InitGoogleTest(&argc, argv);

#if defined( NN_BUILD_CONFIG_OS_SUPPORTS_HORIZON )
    const size_t GraphicsSystemMemorySize = 8 * 1024 * 1024;
    void* pGraphicMemory = malloc(GraphicsSystemMemorySize);
    nv::SetGraphicsAllocator(NvAllocate, NvFree, NvReallocate, NULL);
    nv::InitializeGraphics(pGraphicMemory, GraphicsSystemMemorySize);
#endif

    nnt::g3d::InitializeG3dTest(*GetDevice());

    int result = RUN_ALL_TESTS();

    nnt::g3d::FinalizeG3dTest( *GetDevice() );

    nnt::Exit(result);
}
